/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import ai.h2o.algos.tree.INode;
import ai.h2o.algos.tree.INodeStat;
import hex.genmodel.PredictContributions;
import hex.genmodel.PredictContributionsFactory;
import hex.genmodel.algos.tree.ContributionsPredictor;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.algos.tree.SharedTreeSubgraph;
import hex.genmodel.algos.tree.TreeSHAP;
import hex.genmodel.algos.tree.TreeSHAPEnsemble;
import hex.genmodel.algos.tree.TreeSHAPPredictor;
import java.util.ArrayList;

public abstract class SharedTreeMojoModelWithContributions
extends SharedTreeMojoModel
implements PredictContributionsFactory {
    protected SharedTreeMojoModelWithContributions(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public PredictContributions makeContributionsPredictor() {
        if (this._nclasses > 2) {
            throw new UnsupportedOperationException("Predicting contributions for multinomial classification problems is not yet supported.");
        }
        SharedTreeGraph graph = this.computeGraph(-1);
        SharedTreeNode[] empty = new SharedTreeNode[]{};
        ArrayList treeSHAPs = new ArrayList(graph.subgraphArray.size());
        for (SharedTreeSubgraph tree : graph.subgraphArray) {
            INode[] nodes = tree.nodesArray.toArray(empty);
            treeSHAPs.add(new TreeSHAP(nodes, (INodeStat[])nodes, 0));
        }
        TreeSHAPEnsemble<double[]> predictor = new TreeSHAPEnsemble<double[]>(treeSHAPs, (float)this.getInitF());
        return this.getContributionsPredictor(predictor);
    }

    @Override
    public double getInitF() {
        return 0.0;
    }

    protected abstract PredictContributions getContributionsPredictor(TreeSHAPPredictor<double[]> var1);

    protected static class SharedTreeContributionsPredictor
    extends ContributionsPredictor<double[]> {
        public SharedTreeContributionsPredictor(SharedTreeMojoModel model, TreeSHAPPredictor<double[]> treeSHAPPredictor) {
            super(model._nfeatures + 1, treeSHAPPredictor);
        }

        @Override
        protected final double[] toInputRow(double[] input) {
            return input;
        }
    }
}

