/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class ArrayUtils {
    public static double l2norm(double[] x) {
        return Math.sqrt(ArrayUtils.l2norm2(x));
    }

    public static double l2norm2(double[] x) {
        return ArrayUtils.l2norm2(x, false);
    }

    public static double l2norm2(double[] x, boolean skipLast) {
        int last = x.length - (skipLast ? 1 : 0);
        double sum = 0.0;
        for (int i = 0; i < last; ++i) {
            sum += x[i] * x[i];
        }
        return sum;
    }

    public static boolean isBoolColumn(String[] domains) {
        if (domains != null) {
            if (domains.length == 2) {
                if (domains[0].equalsIgnoreCase("true") && domains[1].equalsIgnoreCase("false")) {
                    return true;
                }
                if (domains[1].equalsIgnoreCase("true") && domains[0].equalsIgnoreCase("false")) {
                    return true;
                }
            } else if (domains.length == 1 && (domains[0].equalsIgnoreCase("true") || domains[0].equalsIgnoreCase("false"))) {
                return true;
            }
        }
        return false;
    }

    public static int maxIndex(double[] from, Random rand) {
        assert (rand != null);
        int result = 0;
        int maxCount = 0;
        for (int i = 1; i < from.length; ++i) {
            if (from[i] > from[result]) {
                result = i;
                maxCount = 1;
                continue;
            }
            if (from[i] != from[result] || rand.nextInt(++maxCount) != 0) continue;
            result = i;
        }
        return result;
    }

    public static int maxIndex(double[] from) {
        int result = 0;
        for (int i = 1; i < from.length; ++i) {
            if (!(from[i] > from[result])) continue;
            result = i;
        }
        return result;
    }

    public static void sort(int[] idxs, double[] values) {
        ArrayUtils.sort(idxs, values, 500);
    }

    public static void sort(int[] idxs, final double[] values, int cutoff) {
        if (idxs.length < cutoff) {
            for (int i = 0; i < idxs.length; ++i) {
                for (int j = i; j > 0 && values[idxs[j - 1]] > values[idxs[j]]; --j) {
                    int tmp = idxs[j];
                    idxs[j] = idxs[j - 1];
                    idxs[j - 1] = tmp;
                }
            }
        } else {
            int i;
            Integer[] d = new Integer[idxs.length];
            for (i = 0; i < idxs.length; ++i) {
                d[i] = idxs[i];
            }
            Arrays.sort(d, new Comparator<Integer>(){

                @Override
                public int compare(Integer x, Integer y) {
                    return values[x] < values[y] ? -1 : (values[x] > values[y] ? 1 : 0);
                }
            });
            for (i = 0; i < idxs.length; ++i) {
                idxs[i] = d[i];
            }
        }
    }

    public static String[] append(String[] a, String ... b) {
        if (a == null) {
            return b;
        }
        String[] tmp = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }
}

