/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.gam;

import hex.genmodel.ConverterFactoryProvidingModel;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.gam.GamRowToRawDataConverter;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import hex.genmodel.easy.CategoricalEncoder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.RowToRawDataConverter;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.genmodel.utils.LinkFunctionType;
import java.util.Map;

public abstract class GamMojoModelBase
extends MojoModel
implements ConverterFactoryProvidingModel {
    public LinkFunctionType _link_function;
    boolean _useAllFactorLevels;
    int _cats;
    int[] _catNAFills;
    int[] _catOffsets;
    int _nums;
    int _numsCenter;
    double[] _numNAFills;
    double[] _numNAFillsCenter;
    boolean _meanImputation;
    double[] _beta;
    double[] _beta_no_center;
    double[] _beta_center;
    double[][] _beta_multinomial;
    double[][] _beta_multinomial_no_center;
    double[][] _beta_multinomial_center;
    DistributionFamily _family;
    String[] _gam_columns;
    int _num_gam_columns;
    int[] _bs;
    int[] _num_knots;
    double[][] _knots;
    double[][][] _binvD;
    double[][][] _zTranspose;
    String[][] _gamColNames;
    String[][] _gamColNamesCenter;
    String[] _names_no_centering;
    int _totFeatureSize;
    int _betaSizePerClass;
    int _betaCenterSizePerClass;
    double _tweedieLinkPower;
    double[][] _basisVals;
    double[][] _hj;
    int _numExpandedGamCols;
    int _lastClass;

    GamMojoModelBase(String[] columns, String[][] domains, String responseColumn) {
        super(columns, domains, responseColumn);
    }

    @Override
    public double[] score0(double[] row, double[] preds) {
        if (this._meanImputation) {
            this.imputeMissingWithMeans(row);
        }
        return this.gamScore0(row, preds);
    }

    void init() {
        this._basisVals = new double[this._gam_columns.length][];
        this._hj = new double[this._gam_columns.length][];
        for (int ind = 0; ind < this._num_gam_columns; ++ind) {
            this._basisVals[ind] = new double[this._num_knots[ind]];
            this._hj[ind] = ArrayUtils.eleDiff(this._knots[ind]);
        }
        this._lastClass = this._nclasses - 1;
    }

    abstract double[] gamScore0(double[] var1, double[] var2);

    private void imputeMissingWithMeans(double[] data) {
        int ind;
        for (ind = 0; ind < this._cats; ++ind) {
            if (!Double.isNaN(data[ind])) continue;
            data[ind] = this._catNAFills[ind];
        }
        if (data.length == this.nfeatures()) {
            for (ind = this._cats; ind < this._numsCenter + this._cats; ++ind) {
                if (!Double.isNaN(data[ind])) continue;
                data[ind] = this._numNAFillsCenter[ind - this._cats];
            }
        } else {
            for (ind = 0; ind < this._nums; ++ind) {
                int colInd = ind + this._cats;
                if (!Double.isNaN(data[colInd])) continue;
                data[colInd] = this._numNAFills[ind];
            }
        }
    }

    double evalLink(double val) {
        switch (this._link_function) {
            case identity: {
                return GenModel.GLM_identityInv(val);
            }
            case logit: {
                return GenModel.GLM_logitInv(val);
            }
            case log: {
                return GenModel.GLM_logInv(val);
            }
            case inverse: {
                return GenModel.GLM_inverseInv(val);
            }
            case tweedie: {
                return GenModel.GLM_tweedieInv(val, this._tweedieLinkPower);
            }
        }
        throw new UnsupportedOperationException("Unexpected link function " + (Object)((Object)this._link_function));
    }

    int readCatVal(double data, int dataIndex) {
        int ival;
        int n = ival = this._useAllFactorLevels ? (int)data : (int)data - 1;
        if (ival < 0) {
            return -1;
        }
        return ival += this._catOffsets[dataIndex];
    }

    double generateEta(double[] beta, double[] data) {
        double eta = 0.0;
        for (int i = 0; i < this._catOffsets.length - 1; ++i) {
            int ival = this.readCatVal(data[i], i);
            if (ival >= this._catOffsets[i + 1] || ival < 0) continue;
            eta += beta[ival];
        }
        int noff = this._catOffsets[this._cats] - this._cats;
        for (int i = this._cats; i < beta.length - 1 - noff; ++i) {
            eta += beta[noff + i] * data[i];
        }
        return eta += beta[beta.length - 1];
    }

    private boolean gamificationNeeded(double[] rawData, int gamColStart) {
        for (int cind = gamColStart; cind < rawData.length; ++cind) {
            if (Double.isNaN(rawData[cind])) continue;
            return false;
        }
        return true;
    }

    double[] addExpandGamCols(double[] rawData, RowData rowData) {
        int dataIndEnd = this._totFeatureSize - this._numExpandedGamCols;
        if (!this.gamificationNeeded(rawData, dataIndEnd)) {
            return rawData;
        }
        double[] dataWithGamifiedColumns = ArrayUtils.nanArray(this._totFeatureSize);
        System.arraycopy(rawData, 0, dataWithGamifiedColumns, 0, dataIndEnd);
        for (int cind = 0; cind < this._num_gam_columns; ++cind) {
            double gam_col_data;
            Object dataObject;
            if (this._bs[cind] == 0) {
                dataObject = rowData.get(this._gam_columns[cind]);
                gam_col_data = Double.NaN;
                if (dataObject == null) {
                    dataIndEnd += this._num_knots[cind];
                    continue;
                }
            } else {
                throw new IllegalArgumentException("spline type not implemented!");
            }
            gam_col_data = dataObject instanceof String ? Double.parseDouble((String)dataObject) : (Double)dataObject;
            GamUtilsCubicRegression.expandOneGamCol(gam_col_data, this._binvD[cind], this._basisVals[cind], this._hj[cind], this._knots[cind]);
            System.arraycopy(this._basisVals[cind], 0, dataWithGamifiedColumns, dataIndEnd, this._num_knots[cind]);
            dataIndEnd += this._num_knots[cind];
        }
        return dataWithGamifiedColumns;
    }

    @Override
    public RowToRawDataConverter makeConverterFactory(Map<String, Integer> modelColumnNameToIndexMap, Map<Integer, CategoricalEncoder> domainMap, EasyPredictModelWrapper.ErrorConsumer errorConsumer, EasyPredictModelWrapper.Config config) {
        return new GamRowToRawDataConverter(this, modelColumnNameToIndexMap, domainMap, errorConsumer, config);
    }
}

