/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonObject;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import java.io.Serializable;

public class VariableImportances
implements Serializable {
    public final String[] _variables;
    public final double[] _importances;

    public VariableImportances(String[] variableNames, double[] relativeImportances) {
        this._variables = variableNames;
        this._importances = relativeImportances;
    }

    protected static VariableImportances extractFromJson(JsonObject modelJson) {
        Table table = ModelJsonReader.readTable(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] relativeVarimps = new double[table.rows()];
        String[] varNames = new String[table.rows()];
        int varImportanceCol = table.findColumnIndex("Relative Importance");
        int varNameCol = table.findColumnIndex("Variable");
        if (varImportanceCol == -1) {
            return null;
        }
        if (varNameCol == -1) {
            return null;
        }
        for (int i = 0; i < table.rows(); ++i) {
            relativeVarimps[i] = (Double)table.getCell(varImportanceCol, i);
            varNames[i] = (String)table.getCell(varNameCol, i);
        }
        return new VariableImportances(varNames, relativeVarimps);
    }
}

