/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.targetencoder;

import hex.genmodel.ModelMojoReader;
import hex.genmodel.algos.targetencoder.EncodingMap;
import hex.genmodel.algos.targetencoder.EncodingMaps;
import hex.genmodel.algos.targetencoder.TargetEncoderMojoModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TargetEncoderMojoReader
extends ModelMojoReader<TargetEncoderMojoModel> {
    public static final String ENCODING_MAP_PATH = "feature_engineering/target_encoding/encoding_map.ini";
    public static final String MISSING_VALUES_PRESENCE_MAP_PATH = "feature_engineering/target_encoding/te_column_name_to_missing_values_presence.ini";

    @Override
    public String getModelName() {
        return "TargetEncoder";
    }

    @Override
    protected void readModelData() throws IOException {
        ((TargetEncoderMojoModel)this._model)._keepOriginalCategoricalColumns = this.readkv("keep_original_categorical_columns", false);
        ((TargetEncoderMojoModel)this._model)._withBlending = (Boolean)this.readkv("with_blending");
        if (((TargetEncoderMojoModel)this._model)._withBlending) {
            ((TargetEncoderMojoModel)this._model)._inflectionPoint = (Double)this.readkv("inflection_point");
            ((TargetEncoderMojoModel)this._model)._smoothing = (Double)this.readkv("smoothing");
        }
        ((TargetEncoderMojoModel)this._model)._nonPredictors = Arrays.asList(this.readkv("non_predictors", "").split(";"));
        ((TargetEncoderMojoModel)this._model).setEncodings(this.parseEncodingMap());
        ((TargetEncoderMojoModel)this._model)._teColumn2HasNAs = this.parseTEColumnsToHasNAs();
    }

    @Override
    protected TargetEncoderMojoModel makeModel(String[] columns, String[][] domains, String responseColumn) {
        return new TargetEncoderMojoModel(columns, domains, responseColumn);
    }

    private Map<String, Boolean> parseTEColumnsToHasNAs() throws IOException {
        HashMap<String, Boolean> cols2HasNAs = new HashMap<String, Boolean>();
        if (this.exists(MISSING_VALUES_PRESENCE_MAP_PATH)) {
            Iterable<String> parsedFile = this.readtext(MISSING_VALUES_PRESENCE_MAP_PATH);
            for (String line : parsedFile) {
                String[] indexAndPresence = line.split("\\s*=\\s*", 2);
                cols2HasNAs.put(indexAndPresence[0], Integer.parseInt(indexAndPresence[1]) == 1);
            }
        }
        return cols2HasNAs;
    }

    protected EncodingMaps parseEncodingMap() throws IOException {
        if (!this.exists(ENCODING_MAP_PATH)) {
            return null;
        }
        HashMap<String, EncodingMap> encodingMaps = new HashMap<String, EncodingMap>();
        try (BufferedReader source = this.getMojoReaderBackend().getTextFile(ENCODING_MAP_PATH);){
            EncodingMap colEncodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
            String sectionName = null;
            while (true) {
                String line;
                if ((line = source.readLine()) == null) {
                    encodingMaps.put(sectionName, colEncodingMap);
                    break;
                }
                line = line.trim();
                String matchSection = this.matchNewSection(line);
                if (sectionName == null || matchSection != null) {
                    if (sectionName != null) {
                        encodingMaps.put(sectionName, colEncodingMap);
                    }
                    sectionName = matchSection;
                    colEncodingMap = new EncodingMap(((TargetEncoderMojoModel)this._model).nclasses());
                    continue;
                }
                String[] res = line.split("\\s*=\\s*", 2);
                double[] components = this.processEncodingsComponents(res[1].split(" "));
                colEncodingMap.add(Integer.parseInt(res[0]), components);
            }
        }
        return new EncodingMaps(encodingMaps);
    }

    private String matchNewSection(String line) {
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private double[] processEncodingsComponents(String[] componentsStr) {
        double[] numDen = new double[componentsStr.length];
        int i = 0;
        for (String str : componentsStr) {
            numDen[i] = Double.parseDouble(str);
            ++i;
        }
        return numDen;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }
}

