/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hex.genmodel.MojoModel;
import hex.genmodel.algos.glm.GlmMojoModel;
import hex.genmodel.algos.glm.GlmMultinomialMojoModel;
import hex.genmodel.algos.glm.GlmOrdinalMojoModel;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.metrics.MojoModelMetrics;
import hex.genmodel.attributes.metrics.MojoModelMetricsAnomaly;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsBinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomial;
import hex.genmodel.attributes.metrics.MojoModelMetricsMultinomialGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinal;
import hex.genmodel.attributes.metrics.MojoModelMetricsOrdinalGLM;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegression;
import hex.genmodel.attributes.metrics.MojoModelMetricsRegressionGLM;
import hex.genmodel.attributes.parameters.ModelParameter;
import java.io.Serializable;
import java.util.ArrayList;

public class ModelAttributes
implements Serializable {
    private final Table _modelSummary;
    private final Table _scoring_history;
    private final MojoModelMetrics _trainingMetrics;
    private final MojoModelMetrics _validation_metrics;
    private final MojoModelMetrics _cross_validation_metrics;
    private final Table _cross_validation_metrics_summary;
    private final ModelParameter[] _model_parameters;

    public ModelAttributes(MojoModel model, JsonObject modelJson) {
        this._modelSummary = ModelJsonReader.readTable(modelJson, "output.model_summary");
        this._scoring_history = ModelJsonReader.readTable(modelJson, "output.scoring_history");
        if (ModelJsonReader.elementExists((JsonElement)modelJson, "output.training_metrics")) {
            this._trainingMetrics = ModelAttributes.determineModelMetricsType(model);
            ModelJsonReader.fillObject(this._trainingMetrics, (JsonElement)modelJson, "output.training_metrics");
        } else {
            this._trainingMetrics = null;
        }
        if (ModelJsonReader.elementExists((JsonElement)modelJson, "output.validation_metrics")) {
            this._validation_metrics = ModelAttributes.determineModelMetricsType(model);
            ModelJsonReader.fillObject(this._validation_metrics, (JsonElement)modelJson, "output.validation_metrics");
        } else {
            this._validation_metrics = null;
        }
        if (ModelJsonReader.elementExists((JsonElement)modelJson, "output.cross_validation_metrics")) {
            this._cross_validation_metrics_summary = ModelJsonReader.readTable(modelJson, "output.cross_validation_metrics_summary");
            this._cross_validation_metrics = ModelAttributes.determineModelMetricsType(model);
            ModelJsonReader.fillObject(this._cross_validation_metrics, (JsonElement)modelJson, "output.cross_validation_metrics");
        } else {
            this._cross_validation_metrics = null;
            this._cross_validation_metrics_summary = null;
        }
        if (ModelJsonReader.elementExists((JsonElement)modelJson, "parameters")) {
            int i;
            JsonArray jsonParameters = ModelJsonReader.findInJson((JsonElement)modelJson, "parameters").getAsJsonArray();
            ArrayList<ModelParameter> modelParameters = new ArrayList<ModelParameter>(jsonParameters.size());
            for (i = 0; i < jsonParameters.size(); ++i) {
                modelParameters.add(new ModelParameter());
            }
            ModelJsonReader.fillObjects(modelParameters, jsonParameters);
            for (i = 0; i < modelParameters.size(); ++i) {
                if (!"model_id".equals(((ModelParameter)modelParameters.get(i)).getName())) continue;
                modelParameters.remove(i);
            }
            this._model_parameters = modelParameters.toArray(new ModelParameter[modelParameters.size()]);
        } else {
            this._model_parameters = new ModelParameter[0];
        }
    }

    private static MojoModelMetrics determineModelMetricsType(MojoModel mojoModel) {
        switch (mojoModel.getModelCategory()) {
            case Binomial: {
                if (mojoModel instanceof GlmMojoModel) {
                    return new MojoModelMetricsBinomialGLM();
                }
                return new MojoModelMetricsBinomial();
            }
            case Multinomial: {
                if (mojoModel instanceof GlmMultinomialMojoModel) {
                    return new MojoModelMetricsMultinomialGLM();
                }
                return new MojoModelMetricsMultinomial();
            }
            case Regression: {
                if (mojoModel instanceof GlmMojoModel) {
                    return new MojoModelMetricsRegressionGLM();
                }
                return new MojoModelMetricsRegression();
            }
            case AnomalyDetection: {
                return new MojoModelMetricsAnomaly();
            }
            case Ordinal: {
                if (mojoModel instanceof GlmOrdinalMojoModel) {
                    return new MojoModelMetricsOrdinalGLM();
                }
                return new MojoModelMetricsOrdinal();
            }
        }
        return new MojoModelMetrics();
    }

    public Table getModelSummary() {
        return this._modelSummary;
    }

    public Table getScoringHistory() {
        return this._scoring_history;
    }

    public MojoModelMetrics getTrainingMetrics() {
        return this._trainingMetrics;
    }

    public MojoModelMetrics getValidationMetrics() {
        return this._validation_metrics;
    }

    public MojoModelMetrics getCrossValidationMetrics() {
        return this._cross_validation_metrics;
    }

    public Table getCrossValidationMetricsSummary() {
        return this._cross_validation_metrics_summary;
    }

    public ModelParameter[] getModelParameters() {
        return this._model_parameters;
    }

    public Object getParameterValueByName(String name) {
        for (ModelParameter parameter : this._model_parameters) {
            if (!parameter.name.equals(name)) continue;
            return parameter.actual_value;
        }
        return null;
    }
}

