/*
 * Decompiled with CFR 0.152.
 */
package water.util.comparison.string;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.comparators.JaccardIndexComparator;
import no.priv.garshol.duke.comparators.LongestCommonSubstring;
import no.priv.garshol.duke.comparators.QGramComparator;
import no.priv.garshol.duke.comparators.SoundexComparator;
import water.util.comparison.string.H2OJaroWinklerComparator;
import water.util.comparison.string.LevenshteinDistanceComparator;

public class StringComparatorFactory {
    public static Comparator makeComparator(String measure) {
        switch (measure) {
            case "jaccard": 
            case "JaccardIndex": {
                return new JaccardIndexComparator();
            }
            case "jw": 
            case "JaroWinkler": {
                return new H2OJaroWinklerComparator();
            }
            case "lv": 
            case "Levenshtein": {
                return new LevenshteinDistanceComparator();
            }
            case "lcs": 
            case "LongestCommonSubstring": {
                return new LongestCommonSubstring();
            }
            case "qgram": 
            case "QGram": {
                return new QGramComparator();
            }
            case "soundex": 
            case "Soundex": {
                return new SoundexComparator();
            }
        }
        throw new IllegalArgumentException("Unknown comparator: " + measure);
    }
}

