/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.isotonic;

import java.util.Arrays;

public class IsotonicRegressionUtils {
    public static double score(double x, double minX, double maxX, double[] thresholdsX, double[] thresholdsY) {
        double y;
        if (Double.isNaN(x) || x < minX || x > maxX) {
            return Double.NaN;
        }
        int pos = Arrays.binarySearch(thresholdsX, x);
        if (pos >= 0) {
            y = thresholdsY[pos];
        } else {
            int lo = -pos - 2;
            int hi = lo + 1;
            assert (lo >= 0);
            assert (hi < thresholdsX.length);
            assert (x > thresholdsX[lo]);
            assert (x < thresholdsX[hi]);
            y = IsotonicRegressionUtils.interpolate(x, thresholdsX[lo], thresholdsX[hi], thresholdsY[lo], thresholdsY[hi]);
        }
        return y;
    }

    public static double clip(double x, double min, double max) {
        double clipped = Double.isNaN(x) ? Double.NaN : (x < min ? min : Math.min(x, max));
        return clipped;
    }

    static double interpolate(double x, double xLo, double xHi, double yLo, double yHi) {
        double slope = (yHi - yLo) / (xHi - xLo);
        return yLo + slope * (x - xLo);
    }
}

