/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.IGenModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import water.genmodel.IGeneratedModel;

public abstract class GenModel
implements IGenModel,
IGeneratedModel,
Serializable {
    public final String[] _names;
    public final String[][] _domains;

    public GenModel(String[] names, String[][] domains) {
        this._names = names;
        this._domains = domains;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public int nfeatures() {
        return this._names.length;
    }

    @Override
    public int nclasses() {
        return 0;
    }

    @Override
    public int getNumCols() {
        return this.nfeatures();
    }

    @Override
    public int getResponseIdx() {
        if (!this.isSupervised()) {
            throw new UnsupportedOperationException("Cannot provide response index for unsupervised models.");
        }
        return this._domains.length - 1;
    }

    @Override
    public String getResponseName() {
        throw new UnsupportedOperationException("getResponseName is not supported in h2o-dev!");
    }

    @Override
    public int getNumResponseClasses() {
        if (this.isClassifier()) {
            return this.nclasses();
        }
        throw new UnsupportedOperationException("Cannot provide number of response classes for non-classifiers.");
    }

    @Override
    public String[] getNames() {
        return this._names;
    }

    @Override
    public int getColIdx(String name) {
        String[] names = this.getNames();
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getNumClasses(int colIdx) {
        String[] domval = this.getDomainValues(colIdx);
        return domval != null ? domval.length : -1;
    }

    @Override
    public String[] getDomainValues(String name) {
        int colIdx = this.getColIdx(name);
        return colIdx != -1 ? this.getDomainValues(colIdx) : null;
    }

    @Override
    public String[] getDomainValues(int i) {
        return this.getDomainValues()[i];
    }

    @Override
    public int mapEnum(int colIdx, String enumValue) {
        String[] domain = this.getDomainValues(colIdx);
        if (domain == null || domain.length == 0) {
            return -1;
        }
        for (int i = 0; i < domain.length; ++i) {
            if (!enumValue.equals(domain[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[][] getDomainValues() {
        return this._domains;
    }

    @Override
    public boolean isClassifier() {
        ModelCategory cat = this.getModelCategory();
        return cat == ModelCategory.Binomial || cat == ModelCategory.Multinomial;
    }

    @Override
    public boolean isAutoEncoder() {
        ModelCategory cat = this.getModelCategory();
        return cat == ModelCategory.AutoEncoder;
    }

    @Override
    public int getPredsSize() {
        return this.isClassifier() ? 1 + this.getNumResponseClasses() : 2;
    }

    public String getHeader() {
        return null;
    }

    public double[] map(Map<String, Double> row, double[] data) {
        String[] colNames = this._names;
        for (int i = 0; i < this.nfeatures(); ++i) {
            Double d = row.get(colNames[i]);
            data[i] = d == null ? Double.NaN : d;
        }
        return data;
    }

    @Override
    public float[] predict(double[] data, float[] preds) {
        return this.predict(data, preds, 0);
    }

    @Override
    public float[] predict(double[] data, float[] preds, int maxIters) {
        throw new UnsupportedOperationException("Unsupported operation - use score0 method!");
    }

    public abstract double[] score0(double[] var1, double[] var2);

    public double[] score0(Map<String, Double> row, double[] data, double[] preds) {
        return this.score0(this.map(row, data), preds);
    }

    public double[] score0(Map<String, Double> row, double[] preds) {
        return this.score0(this.map(row, new double[this.nfeatures()]), preds);
    }

    public double[] score0(Map<String, Double> row) {
        return this.score0(this.map(row, new double[this.nfeatures()]), new double[this.nclasses() + 1]);
    }

    public static double[] correctProbabilities(double[] scored, double[] priorClassDist, double[] modelClassDist) {
        double probsum = 0.0;
        for (int c = 1; c < scored.length; ++c) {
            double original_fraction = priorClassDist[c - 1];
            double oversampled_fraction = modelClassDist[c - 1];
            assert (!Double.isNaN(scored[c])) : "Predicted NaN class probability";
            if (original_fraction != 0.0 && oversampled_fraction != 0.0) {
                int n = c;
                scored[n] = scored[n] * (original_fraction / oversampled_fraction);
            }
            probsum += scored[c];
        }
        if (probsum > 0.0) {
            int i = 1;
            while (i < scored.length) {
                int n = i++;
                scored[n] = scored[n] / probsum;
            }
        }
        return scored;
    }

    public static int getPrediction(double[] preds, double[] priorClassDist, double[] data, double threshold) {
        if (preds.length == 3) {
            return preds[2] >= threshold ? 1 : 0;
        }
        ArrayList<Integer> ties = new ArrayList<Integer>();
        ties.add(0);
        int best = 1;
        int tieCnt = 0;
        for (int c = 2; c < preds.length; ++c) {
            if (preds[best] < preds[c]) {
                best = c;
                tieCnt = 0;
                continue;
            }
            if (preds[best] != preds[c]) continue;
            ++tieCnt;
            ties.add(c - 1);
        }
        if (tieCnt == 0) {
            return best - 1;
        }
        long hash = 0L;
        if (data != null) {
            for (double d : data) {
                hash ^= Double.doubleToRawLongBits(d) >> 6;
            }
        }
        if (priorClassDist != null) {
            double sum = 0.0;
            for (Integer i : ties) {
                sum += priorClassDist[i];
            }
            Random rng = new Random(hash);
            double tie = rng.nextDouble();
            double partialSum = 0.0;
            for (Integer i : ties) {
                if (!(tie <= (partialSum += priorClassDist[i] / sum))) continue;
                return i;
            }
        }
        double res = preds[best];
        int idx = (int)hash % (tieCnt + 1);
        for (best = 1; best < preds.length; ++best) {
            if (res != preds[best] || --idx >= 0) continue;
            return best - 1;
        }
        throw new RuntimeException("Should Not Reach Here");
    }

    public static boolean bitSetContains(byte[] bits, int bitoff, int num) {
        if (Integer.MIN_VALUE == num) {
            num = 0;
        }
        assert (num >= 0);
        return (num -= bitoff) >= 0 && num < bits.length << 3 && (bits[num >> 3] & 1 << (num & 7)) != 0;
    }

    public static int KMeans_closest(double[][] centers, double[] point, String[][] domains, double[] means, double[] mults) {
        int min = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            double sqr = GenModel.KMeans_distance(centers[cluster], point, domains, means, mults);
            if (!(sqr < minSqr)) continue;
            min = cluster;
            minSqr = sqr;
        }
        return min;
    }

    public static double[] KMeans_simplex(double[][] centers, double[] point, String[][] domains, double[] means, double[] mults) {
        double[] dist = new double[centers.length];
        double sum = 0.0;
        double inv_sum = 0.0;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            dist[cluster] = GenModel.KMeans_distance(centers[cluster], point, domains, means, mults);
            sum += dist[cluster];
            inv_sum += 1.0 / dist[cluster];
        }
        double[] ratios = new double[centers.length];
        if (sum == 0.0) {
            Random rng = new Random();
            int idx = rng.nextInt(centers.length);
            ratios[idx] = 1.0;
        } else {
            int cluster;
            int idx = -1;
            for (cluster = 0; cluster < centers.length; ++cluster) {
                if (dist[cluster] != 0.0) continue;
                idx = cluster;
                break;
            }
            if (idx == -1) {
                for (cluster = 0; cluster < centers.length; ++cluster) {
                    ratios[cluster] = 1.0 / (dist[cluster] * inv_sum);
                }
            } else {
                ratios[idx] = 1.0;
            }
        }
        return ratios;
    }

    public static double KMeans_distance(double[] center, float[] point, String[][] domains, double[] means, double[] mults, double[] colSum, double[] colSumSq) {
        double sqr = 0.0;
        int pts = point.length;
        for (int column = 0; column < center.length; ++column) {
            float d = point[column];
            if (Float.isNaN(d)) {
                --pts;
                continue;
            }
            if (domains[column] != null) {
                if ((double)d != center[column]) {
                    sqr += 1.0;
                }
            } else {
                if (mults != null) {
                    d = (float)((double)d - means[column]);
                    d = (float)((double)d * mults[column]);
                }
                double delta = (double)d - center[column];
                sqr += delta * delta;
            }
            int n = column;
            colSum[n] = colSum[n] + (double)d;
            int n2 = column;
            colSumSq[n2] = colSumSq[n2] + (double)(d * d);
        }
        if (0 < pts && pts < point.length) {
            double scale = point.length / pts;
            sqr *= scale;
        }
        return sqr;
    }

    public static double KMeans_distance(double[] center, double[] point, String[][] domains, double[] means, double[] mults) {
        double sqr = 0.0;
        int pts = point.length;
        for (int column = 0; column < center.length; ++column) {
            double d = point[column];
            if (Double.isNaN(d)) {
                --pts;
                continue;
            }
            if (domains[column] != null) {
                if (d == center[column]) continue;
                sqr += 1.0;
                continue;
            }
            if (mults != null) {
                d -= means[column];
                d *= mults[column];
            }
            double delta = d - center[column];
            sqr += delta * delta;
        }
        if (0 < pts && pts < point.length) {
            sqr *= (double)(point.length / pts);
        }
        return sqr;
    }

    public static double[] SharedTree_clean(double[] data) {
        double[] fs = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            fs[i] = Double.isNaN(data[i]) ? -1.7976931348623157E308 : data[i];
        }
        return fs;
    }

    public static double log_rescale(double[] preds) {
        double maxval = Double.NEGATIVE_INFINITY;
        for (int k = 1; k < preds.length; ++k) {
            maxval = Math.max(maxval, preds[k]);
        }
        assert (!Double.isInfinite(maxval)) : "Something is wrong with GBM trees since returned prediction is " + Arrays.toString(preds);
        double dsum = 0.0;
        for (int k = 1; k < preds.length; ++k) {
            preds[k] = Math.exp(preds[k] - maxval);
            dsum += preds[k];
        }
        return dsum;
    }

    public static void GBM_rescale(double[] preds) {
        double sum = GenModel.log_rescale(preds);
        int k = 1;
        while (k < preds.length) {
            int n = k++;
            preds[n] = preds[n] / sum;
        }
    }

    public static double GLM_identityInv(double x) {
        return x;
    }

    public static double GLM_logitInv(double x) {
        return 1.0 / (Math.exp(-x) + 1.0);
    }

    public static double GLM_logInv(double x) {
        return Math.exp(x);
    }

    public static double GLM_inverseInv(double x) {
        double xx = x < 0.0 ? Math.min(-1.0E-5, x) : Math.max(1.0E-5, x);
        return 1.0 / xx;
    }

    public static double GLM_tweedieInv(double x, double tweedie_link_power) {
        return Math.pow(x, 1.0 / tweedie_link_power);
    }
}

