/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.tools;

import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.prediction.AbstractPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;

public class PredictCsv {
    private static String modelClassName;
    private static String inputCSVFileName;
    private static String outputCSVFileName;
    private static int haveHeaders;

    private static void usage() {
        System.out.println("");
        System.out.println("usage:  java [...java args...] hex.genmodel.tools.PredictCsv --header --model modelClassName --input inputCSVFileName --output outputCSVFileName");
        System.out.println("");
        System.out.println("        model class name is something like GBMModel_blahblahblahblah.");
        System.out.println("");
        System.out.println("        inputCSVFileName is the test data set.");
        System.out.println("        Specifying --header is required for h2o-3.");
        System.out.println("");
        System.out.println("        outputCSVFileName is the prediction data set (one row per test data set row).");
        System.out.println("");
        System.exit(1);
    }

    private static void parseArgs(String[] args) {
        block12: for (int i = 0; i < args.length; ++i) {
            String s;
            String string = s = args[i];
            int n = -1;
            switch (string.hashCode()) {
                case -1619625591: {
                    if (!string.equals("--model")) break;
                    n = 0;
                    break;
                }
                case -1623337430: {
                    if (!string.equals("--input")) break;
                    n = 1;
                    break;
                }
                case 1394501281: {
                    if (!string.equals("--output")) break;
                    n = 2;
                    break;
                }
                case 1178742829: {
                    if (!string.equals("--header")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    if (++i >= args.length) {
                        PredictCsv.usage();
                    }
                    modelClassName = args[i];
                    continue block12;
                }
                case 1: {
                    if (++i >= args.length) {
                        PredictCsv.usage();
                    }
                    inputCSVFileName = args[i];
                    continue block12;
                }
                case 2: {
                    if (++i >= args.length) {
                        PredictCsv.usage();
                    }
                    outputCSVFileName = args[i];
                    continue block12;
                }
                case 3: {
                    haveHeaders = 1;
                    continue block12;
                }
                default: {
                    System.out.println("ERROR: Bad parameter: " + s);
                    PredictCsv.usage();
                }
            }
        }
        if (haveHeaders != 1) {
            System.out.println("ERROR: header not specified");
            PredictCsv.usage();
        }
        if (modelClassName == null) {
            System.out.println("ERROR: model not specified");
            PredictCsv.usage();
        }
        if (inputCSVFileName == null) {
            System.out.println("ERROR: input not specified");
            PredictCsv.usage();
        }
        if (outputCSVFileName == null) {
            System.out.println("ERROR: output not specified");
            PredictCsv.usage();
        }
    }

    private static String[] parseHeaderRow(String line) {
        return line.trim().split(",");
    }

    private static RowData parseDataRow(String line, String[] inputColumnNames) {
        String[] inputData = line.trim().split(",");
        RowData row = new RowData();
        block9: for (int i = 0; i < inputColumnNames.length; ++i) {
            String cellData;
            String columnName = inputColumnNames[i];
            String string = cellData = inputData[i];
            int n = -1;
            switch (string.hashCode()) {
                case 0: {
                    if (!string.equals("")) break;
                    n = 0;
                    break;
                }
                case 2483: {
                    if (!string.equals("NA")) break;
                    n = 1;
                    break;
                }
                case 76480: {
                    if (!string.equals("N/A")) break;
                    n = 2;
                    break;
                }
                case 45: {
                    if (!string.equals("-")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    continue block9;
                }
                default: {
                    row.put(columnName, cellData);
                }
            }
        }
        return row;
    }

    static String myDoubleToString(double d) {
        if (Double.isNaN(d)) {
            return "NA";
        }
        return Double.toHexString(d);
    }

    public static void main(String[] args) throws Exception {
        PredictCsv.parseArgs(args);
        GenModel rawModel = (GenModel)Class.forName(modelClassName).newInstance();
        EasyPredictModelWrapper model = new EasyPredictModelWrapper(rawModel);
        ModelCategory category = model.getModelCategory();
        BufferedReader input = new BufferedReader(new FileReader(inputCSVFileName));
        BufferedWriter output = new BufferedWriter(new FileWriter(outputCSVFileName));
        switch (category) {
            case AutoEncoder: {
                output.write(model.getHeader());
                break;
            }
            case Binomial: 
            case Multinomial: {
                String[] responseDomainValues;
                output.write("predict");
                for (String s : responseDomainValues = model.getResponseDomainValues()) {
                    output.write(",");
                    output.write(s);
                }
                break;
            }
            case Clustering: {
                output.write("cluster");
                break;
            }
            case Regression: {
                output.write("predict");
                break;
            }
            default: {
                throw new Exception("Unknown model category " + (Object)((Object)category));
            }
        }
        output.write("\n");
        int lineNum = 0;
        String[] inputColumnNames = null;
        try {
            String line;
            while ((line = input.readLine()) != null) {
                if (++lineNum == 1) {
                    inputColumnNames = PredictCsv.parseHeaderRow(line);
                    continue;
                }
                RowData row = PredictCsv.parseDataRow(line, inputColumnNames);
                switch (category) {
                    case AutoEncoder: {
                        AbstractPrediction p = model.predictAutoEncoder(row);
                        throw new Exception("TODO");
                    }
                    case Binomial: {
                        int i;
                        AbstractPrediction p = model.predictBinomial(row);
                        output.write(((BinomialModelPrediction)p).label);
                        output.write(",");
                        for (i = 0; i < ((BinomialModelPrediction)p).classProbabilities.length; ++i) {
                            if (i > 0) {
                                output.write(",");
                            }
                            output.write(PredictCsv.myDoubleToString(((BinomialModelPrediction)p).classProbabilities[i]));
                        }
                        break;
                    }
                    case Multinomial: {
                        int i;
                        AbstractPrediction p = model.predictMultinomial(row);
                        output.write(((MultinomialModelPrediction)p).label);
                        output.write(",");
                        for (i = 0; i < ((MultinomialModelPrediction)p).classProbabilities.length; ++i) {
                            if (i > 0) {
                                output.write(",");
                            }
                            output.write(PredictCsv.myDoubleToString(((MultinomialModelPrediction)p).classProbabilities[i]));
                        }
                        break;
                    }
                    case Clustering: {
                        AbstractPrediction p = model.predictClustering(row);
                        output.write(PredictCsv.myDoubleToString(((ClusteringModelPrediction)p).cluster));
                        break;
                    }
                    case Regression: {
                        AbstractPrediction p = model.predictRegression(row);
                        output.write(PredictCsv.myDoubleToString(((RegressionModelPrediction)p).value));
                        break;
                    }
                    default: {
                        throw new Exception("Unknown model category " + (Object)((Object)category));
                    }
                }
                output.write("\n");
            }
        }
        catch (Exception e) {
            System.out.println("Caught exception on line " + lineNum);
            System.out.println("");
            e.printStackTrace();
            System.exit(1);
        }
        output.close();
        input.close();
        System.exit(0);
    }

    static {
        haveHeaders = -1;
    }
}

