/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import water.AbstractH2OExtension;
import water.H2O;
import water.Job;
import water.Key;
import water.api.ImportHiveTableHandler;
import water.fvec.Frame;
import water.hive.PartitionFrameJoiner;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;

public class HiveTableImporterImpl
extends AbstractH2OExtension
implements ImportHiveTableHandler.HiveTableImporter {
    private static String NAME = "HiveTableImporter";

    public String getExtensionName() {
        return NAME;
    }

    public Job<Frame> loadHiveTable(String database, String tableName, String[][] partitionFilter, boolean allowDifferentFormats) throws Exception {
        Configuration conf = new Configuration();
        HiveConf hiveConf = new HiveConf(conf, HiveTableImporterImpl.class);
        HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
        if (database == null) {
            database = "default";
        }
        Table table = client.getTable(database, tableName);
        String targetFrame = "hive_" + database + "_" + tableName;
        List partitions = client.listPartitions(database, tableName, (short)Short.MAX_VALUE);
        if (partitions.isEmpty()) {
            return this.loadTable(table, targetFrame);
        }
        List<Partition> filteredPartitions = this.filterPartitions(partitions, partitionFilter);
        if (this.arePartitionsSameFormat(table, filteredPartitions)) {
            return this.loadPartitionsSameFormat(table, filteredPartitions, targetFrame);
        }
        if (allowDifferentFormats) {
            return this.loadPartitions(table, filteredPartitions, targetFrame);
        }
        throw new IllegalArgumentException("Hive table contains partitions with differing formats. Use allow_multi_format if needed.");
    }

    private boolean arePartitionsSameFormat(Table table, List<Partition> partitions) {
        String tableLib = table.getSd().getSerdeInfo().getSerializationLib();
        String tableInput = table.getSd().getInputFormat();
        Map tableParams = table.getSd().getSerdeInfo().getParameters();
        for (Partition part : partitions) {
            if (tableLib.equals(part.getSd().getSerdeInfo().getSerializationLib()) && tableParams.equals(part.getSd().getSerdeInfo().getParameters()) && tableInput.equals(part.getSd().getInputFormat())) continue;
            return false;
        }
        return true;
    }

    private List<Partition> filterPartitions(List<Partition> partitions, String[][] partitionFilter) {
        if (partitionFilter == null || partitionFilter.length == 0) {
            return partitions;
        }
        ArrayList<List<String>> filtersAsLists = new ArrayList<List<String>>(partitionFilter.length);
        for (String[] f : partitionFilter) {
            filtersAsLists.add(Arrays.asList(f));
        }
        ArrayList<Partition> matchedPartitions = new ArrayList<Partition>(partitions.size());
        block1: for (Partition p : partitions) {
            for (List list : filtersAsLists) {
                if (!p.getValues().equals(list)) continue;
                matchedPartitions.add(p);
                continue block1;
            }
        }
        if (matchedPartitions.isEmpty()) {
            throw new IllegalArgumentException("Partition filter did not match any partitions.");
        }
        return matchedPartitions;
    }

    private byte getSeparator(StorageDescriptor sd) {
        Map serDeParams = sd.getSerdeInfo().getParameters();
        String explicitSeparator = (String)serDeParams.get("field.delim");
        if (explicitSeparator != null && !explicitSeparator.isEmpty()) {
            return (byte)explicitSeparator.charAt(0);
        }
        explicitSeparator = (String)serDeParams.get("separatorChar");
        if (explicitSeparator != null && !explicitSeparator.isEmpty()) {
            return (byte)explicitSeparator.charAt(0);
        }
        return 1;
    }

    private ParseSetup guessTableSetup(Key[] filesKeys, Table table) {
        ParseSetup setup = this.guessSetup(filesKeys, table.getSd());
        List tableColumns = table.getSd().getCols();
        String[] columnNames = new String[tableColumns.size()];
        byte[] columnTypes = new byte[tableColumns.size()];
        this.fillColumnNamesAndTypes(tableColumns, columnNames, columnTypes);
        setup.setColumnNames(columnNames);
        setup.setColumnTypes(columnTypes);
        setup.setNumberColumns(columnNames.length);
        return setup;
    }

    private Job<Frame> parseTable(String targetFrame, Key[] filesKeys, ParseSetup setup) {
        Key destinationKey = Key.make((String)targetFrame);
        ParseDataset parse = ParseDataset.parse((Key)destinationKey, (Key[])filesKeys, (boolean)true, (ParseSetup)setup, (boolean)false);
        return parse._job;
    }

    private void checkTableNotEmpty(Table table, Key[] filesKeys) {
        if (filesKeys.length == 0) {
            this.throwTableEmpty(table);
        }
    }

    private void throwTableEmpty(Table table) {
        throw new IllegalArgumentException("Table " + table.getTableName() + " is empty. Nothing to import.");
    }

    private Job<Frame> loadTable(Table table, String targetFrame) {
        Key[] filesKeys = this.importFiles(table.getSd().getLocation());
        this.checkTableNotEmpty(table, filesKeys);
        ParseSetup setup = this.guessTableSetup(filesKeys, table);
        return this.parseTable(targetFrame, filesKeys, setup);
    }

    private Job<Frame> loadPartitionsSameFormat(Table table, List<Partition> partitions, String targetFrame) {
        ArrayList<Key> fileKeysList = new ArrayList<Key>();
        int keyCount = table.getPartitionKeysSize();
        ArrayList<String[]> partitionValuesMap = new ArrayList<String[]>();
        for (Partition p : partitions) {
            Key[] partFileKeys = this.importFiles(p.getSd().getLocation());
            fileKeysList.addAll(Arrays.asList(partFileKeys));
            String[] keyValues = p.getValues().toArray(new String[0]);
            for (Key f : partFileKeys) {
                partitionValuesMap.add(keyValues);
            }
        }
        Key[] filesKeys = fileKeysList.toArray(new Key[0]);
        this.checkTableNotEmpty(table, filesKeys);
        ParseSetup setup = this.guessTableSetup(filesKeys, table);
        String[] partitionKeys = new String[table.getPartitionKeys().size()];
        for (int i = 0; i < table.getPartitionKeys().size(); ++i) {
            partitionKeys[i] = ((FieldSchema)table.getPartitionKeys().get(i)).getName();
        }
        setup.setSyntheticColumns(partitionKeys, (String[][])partitionValuesMap.toArray((T[])new String[0][]));
        return this.parseTable(targetFrame, filesKeys, setup);
    }

    private Job<Frame> loadPartitions(Table table, List<Partition> partitions, String targetFrame) {
        List partitionColumns = table.getPartitionKeys();
        List tableColumns = table.getSd().getCols();
        String[] columnNames = new String[tableColumns.size()];
        byte[] columnTypes = new byte[columnNames.length];
        this.fillColumnNamesAndTypes(tableColumns, columnNames, columnTypes);
        ArrayList<Job<Frame>> parseJobs = new ArrayList<Job<Frame>>(partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            String partitionKey = "_" + targetFrame + "_part_" + i;
            Job<Frame> job = this.parsePartition(partitionColumns, partitions.get(i), partitionKey, columnNames, columnTypes);
            if (job == null) continue;
            parseJobs.add(job);
        }
        if (parseJobs.isEmpty()) {
            this.throwTableEmpty(table);
        }
        Job job = new Job(Key.make((String)targetFrame), Frame.class.getName(), "ImportHiveTable");
        PartitionFrameJoiner joiner = new PartitionFrameJoiner((Job<Frame>)job, table, partitions, targetFrame, parseJobs);
        return job.start((H2O.H2OCountedCompleter)joiner, (long)(partitions.size() + 1));
    }

    private Job<Frame> parsePartition(List<FieldSchema> partitionColumns, Partition part, String targetFrame, String[] columnNames, byte[] columnTypes) {
        Key[] files = this.importFiles(part.getSd().getLocation());
        if (files.length == 0) {
            return null;
        }
        ParseSetup setup = this.guessSetup(files, part.getSd());
        setup.setColumnNames(columnNames);
        setup.setColumnTypes(columnTypes);
        setup.setNumberColumns(columnNames.length);
        ParseDataset parse = ParseDataset.parse((Key)Key.make((String)targetFrame), (Key[])files, (boolean)true, (ParseSetup)setup, (boolean)false);
        return parse._job;
    }

    private void fillColumnNamesAndTypes(List<FieldSchema> columns, String[] columnNames, byte[] columnTypes) {
        for (int i = 0; i < columns.size(); ++i) {
            FieldSchema col = columns.get(i);
            columnNames[i] = col.getName();
            columnTypes[i] = this.convertHiveType(col.getType());
        }
    }

    private ParseSetup guessSetup(Key[] keys, StorageDescriptor sd) {
        ParseSetup parseGuess = new ParseSetup();
        parseGuess.setParseType(DefaultParserProviders.GUESS_INFO);
        parseGuess.setSeparator(this.getSeparator(sd));
        parseGuess.setCheckHeader(-1);
        return ParseSetup.guessSetup((Key[])keys, (ParseSetup)parseGuess);
    }

    private Key[] stringsToKeys(List<String> strings) {
        Key[] keys = new Key[strings.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Key.make((String)strings.get(i));
        }
        return keys;
    }

    private Key[] importFiles(String path) {
        ArrayList files = new ArrayList();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList fails = new ArrayList();
        ArrayList dels = new ArrayList();
        H2O.getPM().importFiles(path, null, files, keys, fails, dels);
        if (!fails.isEmpty()) {
            throw new RuntimeException("Failed to import some files: " + fails.toString());
        }
        return this.stringsToKeys(keys);
    }

    private Set<String> parseColumnFilter(String filter) {
        HashSet<String> columnNames = new HashSet<String>();
        for (String colName : filter.split(",")) {
            columnNames.add(colName.trim());
        }
        return columnNames;
    }

    private byte convertHiveType(String hiveType) {
        switch (hiveType) {
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "integer": 
            case "float": 
            case "double": 
            case "double precision": 
            case "decimal": 
            case "numeric": {
                return 3;
            }
            case "timestamp": 
            case "data": {
                return 5;
            }
            case "interval": 
            case "string": 
            case "varchar": 
            case "char": {
                return 2;
            }
            case "boolean": {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unsupported column type: " + hiveType);
    }
}

