/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Rapids;
import water.rapids.Val;

public class PartitionFrameJoiner
extends H2O.H2OCountedCompleter {
    private final Job<Frame> _job;
    private final Table _table;
    private final List<Partition> _partitions;
    private final String _targetFrame;
    private final List<Job<Frame>> _parseJobs;

    public PartitionFrameJoiner(Job<Frame> job, Table table, List<Partition> partitions, String targetFrame, List<Job<Frame>> parseJobs) {
        this._job = job;
        this._table = table;
        this._partitions = partitions;
        this._targetFrame = targetFrame;
        this._parseJobs = parseJobs;
    }

    public void compute2() {
        int keyCount = this._table.getPartitionKeysSize();
        StringBuilder partKeys = new StringBuilder();
        for (Job<Frame> job : this._parseJobs) {
            Frame partitionFrame = (Frame)job.get();
            String partKey = partitionFrame._key.toString();
            String[] keySplit = partKey.split("_");
            int partIndex = Integer.valueOf(keySplit[keySplit.length - 1]);
            Partition part = this._partitions.get(partIndex);
            partKeys.append(" ").append(partKey);
            long rows = partitionFrame.numRows();
            for (int keyIndex = 0; keyIndex < keyCount; ++keyIndex) {
                String partitionValue = (String)part.getValues().get(keyIndex);
                Vec vec = this.makeVecWithValue(rows, partitionValue);
                partitionFrame.add(((FieldSchema)this._table.getPartitionKeys().get(keyIndex)).getName(), vec);
            }
            this._job.update(1L);
        }
        String tree = "(rbind" + partKeys + ")";
        Val val = Rapids.exec((String)tree);
        Frame merged = val.getFrame();
        merged._key = Key.make((String)this._targetFrame);
        DKV.put((Keyed)merged);
        for (Job<Frame> parseJob : this._parseJobs) {
            DKV.remove((Key)parseJob._result);
        }
        this._job.update(1L);
        this.tryComplete();
    }

    private Vec makeVecWithValue(long rows, final String value) {
        Vec zeroes = Vec.makeZero((long)rows, (byte)2);
        return new MRTask(){

            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, value);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{zeroes})._fr.vecs()[0];
    }
}

