/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import hex.genmodel.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import water.AbstractH2OExtension;
import water.H2O;
import water.Key;
import water.api.SaveToHiveTableHandler;
import water.fvec.Frame;
import water.fvec.Vec;
import water.hive.FrameParquetWriter;
import water.hive.HiveTableImporterImpl;
import water.jdbc.SQLManager;
import water.persist.Persist;
import water.persist.PersistHdfs;

public class HiveFrameSaverImpl
extends AbstractH2OExtension
implements SaveToHiveTableHandler.HiveFrameSaver {
    private static final Logger LOG = Logger.getLogger(HiveTableImporterImpl.class);
    private static final String SQL_DESCRIBE_TABLE = "DESCRIBE %s";

    public String getExtensionName() {
        return "HiveFrameSaver";
    }

    public void saveFrameToHive(Key<Frame> frameKey, String jdbcUrl, String tableName, SaveToHiveTableHandler.HiveFrameSaver.Format format, String configuredTablePath, String configuredTmpPath) {
        String filePath = null;
        try {
            String tmpPath = this.determineTmpPath(configuredTmpPath);
            String storagePath = this.addHdfsPrefixToPath(configuredTablePath);
            filePath = new Path(tmpPath, this.getRandomFileName(format)).toString();
            LOG.info((Object)("Save frame " + frameKey + " to table " + tableName + " in " + jdbcUrl));
            Frame frame = (Frame)frameKey.get();
            if (frame == null) {
                throw new IllegalArgumentException("Frame with key " + frameKey + " not found.");
            }
            this.writeFrameToHdfs(frame, filePath, format);
            this.loadDataIntoTable(jdbcUrl, tableName, storagePath, frame, filePath, format);
            if (filePath != null) {
                this.safelyRemoveDataFile(filePath);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Writing to Hive failed.", e);
            }
            catch (Throwable throwable) {
                if (filePath != null) {
                    this.safelyRemoveDataFile(filePath);
                }
                throw throwable;
            }
        }
    }

    private String determineTmpPath(String configuredTmpPath) throws IOException {
        if (configuredTmpPath == null) {
            FileSystem fs = FileSystem.get((Configuration)PersistHdfs.CONF);
            String res = fs.getUri().toString() + "/tmp";
            LOG.info((Object)("Using default temporary directory " + res));
            return res;
        }
        return this.addHdfsPrefixToPath(configuredTmpPath);
    }

    private String addHdfsPrefixToPath(String path) throws IOException {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("hdfs://")) {
            FileSystem fs = FileSystem.get((Configuration)PersistHdfs.CONF);
            String res = fs.getUri().toString() + "/" + path;
            LOG.info((Object)("Adding file system prefix to relative tmp_path " + res));
            return res;
        }
        return path;
    }

    private String getRandomFileName(SaveToHiveTableHandler.HiveFrameSaver.Format format) {
        return "h2o_save_to_hive_" + UUID.randomUUID().toString() + "." + format.toString().toLowerCase();
    }

    private void safelyRemoveDataFile(String filePath) {
        try {
            Persist p = H2O.getPM().getPersistForURI(URI.create(filePath));
            if (p.exists(filePath)) {
                p.delete(filePath);
            } else {
                LOG.debug((Object)"Data file moved by Hive, doing nothing.");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed cleaning up data file.", (Throwable)e);
        }
    }

    private void writeFrameToHdfs(Frame frame, String filePath, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws IOException {
        switch (format) {
            case CSV: {
                this.writeFrameAsCsv(frame, filePath);
                break;
            }
            case PARQUET: {
                this.writeFrameAsParquet(frame, filePath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported table format " + format);
            }
        }
    }

    private void writeFrameAsParquet(Frame frame, String filePath) throws IOException {
        new FrameParquetWriter().write(frame, filePath);
    }

    private void writeFrameAsCsv(Frame f, String filePath) throws IOException {
        Persist p = H2O.getPM().getPersistForURI(URI.create(filePath));
        try (OutputStream os = p.create(filePath, false);){
            Frame.CSVStreamParams parms = new Frame.CSVStreamParams().setHeaders(false).setEscapeQuotes(true).setEscapeChar('\\');
            InputStream is = f.toCSV(parms);
            IOUtils.copyStream((InputStream)is, (OutputStream)os);
        }
    }

    private void loadDataIntoTable(String url, String table, String tablePath, Frame frame, String filePath, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws IOException {
        try (Connection conn = SQLManager.getConnectionSafe((String)url, null, null);){
            if (this.doesTableExist(conn, table)) {
                throw new IllegalArgumentException("Table " + table + " already exists.");
            }
            this.createTable(conn, table, tablePath, frame, format);
            this.executeDataLoad(conn, table, filePath);
        }
        catch (SQLException e) {
            throw new IOException("Failed to load data into Hive table.", e);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean doesTableExist(Connection conn, String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createTable(Connection conn, String table, String tablePath, Frame frame, SaveToHiveTableHandler.HiveFrameSaver.Format format) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String createQuery = this.makeCreateTableStatement(table, tablePath, frame, format);
            LOG.info((Object)("Creating Hive table " + table + " with SQL: " + createQuery));
            stmt.execute(createQuery);
        }
    }

    private String makeCreateTableStatement(String table, String tablePath, Frame frame, SaveToHiveTableHandler.HiveFrameSaver.Format format) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE ");
        if (tablePath != null) {
            sb.append("EXTERNAL ");
        }
        sb.append("TABLE ").append(table).append(" (");
        switch (format) {
            case CSV: {
                this.makeCreateCSVTableStatement(sb, frame);
                break;
            }
            case PARQUET: {
                this.makeCreateParquetTableStatement(sb, frame);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported table format " + format);
            }
        }
        if (tablePath != null) {
            sb.append("\nLOCATION '").append(tablePath).append("'");
        }
        return sb.toString();
    }

    private void makeCreateCSVTableStatement(StringBuilder sb, Frame frame) {
        for (int i = 0; i < frame.numCols(); ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(frame.name(i)).append(" string");
        }
        sb.append(") ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.OpenCSVSerde'\n").append("WITH SERDEPROPERTIES (\n").append("   \"separatorChar\" = \",\",\n").append("   \"quoteChar\"     = \"\\\"\",\n").append("   \"escapeChar\"    = \"\\\\\") STORED AS TEXTFILE");
    }

    private void makeCreateParquetTableStatement(StringBuilder sb, Frame frame) {
        for (int i = 0; i < frame.numCols(); ++i) {
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(frame.name(i)).append(" ").append(this.sqlDataType(frame.vec(i)));
        }
        sb.append(") STORED AS parquet");
    }

    private String sqlDataType(Vec v) {
        if (v.isCategorical() || v.isUUID() || v.isString()) {
            return "STRING";
        }
        if (v.isInt()) {
            return "BIGINT";
        }
        return "DOUBLE";
    }

    private void executeDataLoad(Connection conn, String table, String filePath) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            LOG.info((Object)("Loading data file " + filePath + " into table " + table));
            stmt.execute("LOAD DATA INPATH '" + filePath + "' OVERWRITE INTO TABLE " + table);
        }
    }
}

