/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import water.AbstractH2OExtension;
import water.H2O;
import water.Job;
import water.Key;
import water.api.ImportHiveTableHandler;
import water.fvec.Frame;
import water.hive.DirectHiveMetadata;
import water.hive.HiveMetaData;
import water.hive.JdbcHiveMetadata;
import water.hive.PartitionFrameJoiner;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;

public class HiveTableImporterImpl
extends AbstractH2OExtension
implements ImportHiveTableHandler.HiveTableImporter {
    private static final Logger LOG = Logger.getLogger(HiveTableImporterImpl.class);

    public String getExtensionName() {
        return "HiveTableImporter";
    }

    private HiveMetaData getMetaDataClient(String database) {
        if (database != null && database.startsWith("jdbc:")) {
            return new JdbcHiveMetadata(database);
        }
        return new DirectHiveMetadata(database);
    }

    public Job<Frame> loadHiveTable(String database, String tableName, String[][] partitionFilter, boolean allowDifferentFormats) throws Exception {
        HiveMetaData.Table table = this.getMetaDataClient(database).getTable(tableName);
        String targetFrame = "hive_table_" + tableName + Key.rand().substring(0, 10);
        if (!table.hasPartitions()) {
            return this.loadTable(table, targetFrame);
        }
        List<HiveMetaData.Partition> filteredPartitions = this.filterPartitions(table, partitionFilter);
        if (this.arePartitionsSameFormat(table, filteredPartitions)) {
            return this.loadPartitionsSameFormat(table, filteredPartitions, targetFrame);
        }
        if (allowDifferentFormats) {
            return this.loadPartitions(table, filteredPartitions, targetFrame);
        }
        throw new IllegalArgumentException("Hive table contains partitions with differing formats. Use allow_multi_format if needed.");
    }

    private boolean arePartitionsSameFormat(HiveMetaData.Table table, List<HiveMetaData.Partition> partitions) {
        String tableLib = table.getSerializationLib();
        String tableInput = table.getInputFormat();
        Map<String, String> tableParams = table.getSerDeParams();
        for (HiveMetaData.Partition part : partitions) {
            if (tableLib.equals(part.getSerializationLib()) && tableParams.equals(part.getSerDeParams()) && tableInput.equals(part.getInputFormat())) continue;
            return false;
        }
        return true;
    }

    private List<HiveMetaData.Partition> filterPartitions(HiveMetaData.Table table, String[][] partitionFilter) {
        if (partitionFilter == null || partitionFilter.length == 0) {
            return table.getPartitions();
        }
        ArrayList<List<String>> filtersAsLists = new ArrayList<List<String>>(partitionFilter.length);
        for (String[] f : partitionFilter) {
            filtersAsLists.add(Arrays.asList(f));
        }
        ArrayList<HiveMetaData.Partition> matchedPartitions = new ArrayList<HiveMetaData.Partition>(table.getPartitions().size());
        block1: for (HiveMetaData.Partition p : table.getPartitions()) {
            for (List list : filtersAsLists) {
                if (!p.getValues().equals(list)) continue;
                matchedPartitions.add(p);
                continue block1;
            }
        }
        if (matchedPartitions.isEmpty()) {
            throw new IllegalArgumentException("Partition filter did not match any partitions.");
        }
        return matchedPartitions;
    }

    private byte getSeparator(HiveMetaData.Storable table) {
        Map<String, String> serDeParams = table.getSerDeParams();
        String explicitSeparator = serDeParams.get("field.delim");
        if (explicitSeparator != null && !explicitSeparator.isEmpty()) {
            return (byte)explicitSeparator.charAt(0);
        }
        explicitSeparator = serDeParams.get("separatorChar");
        if (explicitSeparator != null && !explicitSeparator.isEmpty()) {
            return (byte)explicitSeparator.charAt(0);
        }
        return 1;
    }

    private ParseSetup guessTableSetup(Key[] filesKeys, HiveMetaData.Table table) {
        ParseSetup setup = this.guessSetup(filesKeys, table);
        List<HiveMetaData.Column> tableColumns = table.getColumns();
        String[] columnNames = new String[tableColumns.size()];
        byte[] columnTypes = new byte[tableColumns.size()];
        this.fillColumnNamesAndTypes(tableColumns, columnNames, columnTypes);
        setup.setColumnNames(columnNames);
        setup.setColumnTypes(columnTypes);
        setup.setNumberColumns(columnNames.length);
        return setup;
    }

    private Job<Frame> parseTable(String targetFrame, Key[] filesKeys, ParseSetup setup) {
        Key destinationKey = Key.make((String)targetFrame);
        ParseDataset parse = ParseDataset.parse((Key)destinationKey, (Key[])filesKeys, (boolean)true, (ParseSetup)setup, (boolean)false);
        return parse._job;
    }

    private void checkTableNotEmpty(HiveMetaData.Table table, Key[] filesKeys) {
        if (filesKeys.length == 0) {
            this.throwTableEmpty(table);
        }
    }

    private void throwTableEmpty(HiveMetaData.Table table) {
        throw new IllegalArgumentException("Table " + table.getName() + " is empty. Nothing to import.");
    }

    private Job<Frame> loadTable(HiveMetaData.Table table, String targetFrame) {
        Key[] filesKeys = this.importFiles(table.getLocation());
        this.checkTableNotEmpty(table, filesKeys);
        ParseSetup setup = this.guessTableSetup(filesKeys, table);
        return this.parseTable(targetFrame, filesKeys, setup);
    }

    private Job<Frame> loadPartitionsSameFormat(HiveMetaData.Table table, List<HiveMetaData.Partition> partitions, String targetFrame) {
        ArrayList<Key> fileKeysList = new ArrayList<Key>();
        int keyCount = table.getPartitionKeys().size();
        ArrayList<String[]> partitionValuesMap = new ArrayList<String[]>();
        for (HiveMetaData.Partition p : partitions) {
            Key[] partFileKeys = this.importFiles(p.getLocation());
            fileKeysList.addAll(Arrays.asList(partFileKeys));
            String[] keyValues = p.getValues().toArray(new String[0]);
            for (Key f : partFileKeys) {
                partitionValuesMap.add(keyValues);
            }
        }
        Key[] filesKeys = fileKeysList.toArray(new Key[0]);
        this.checkTableNotEmpty(table, filesKeys);
        ParseSetup setup = this.guessTableSetup(filesKeys, table);
        String[] partitionKeys = new String[table.getPartitionKeys().size()];
        for (int i = 0; i < table.getPartitionKeys().size(); ++i) {
            partitionKeys[i] = table.getPartitionKeys().get(i).getName();
        }
        setup.setSyntheticColumns(partitionKeys, (String[][])partitionValuesMap.toArray((T[])new String[0][]), (byte)2);
        return this.parseTable(targetFrame, filesKeys, setup);
    }

    private Job<Frame> loadPartitions(HiveMetaData.Table table, List<HiveMetaData.Partition> partitions, String targetFrame) {
        List<HiveMetaData.Column> partitionColumns = table.getPartitionKeys();
        List<HiveMetaData.Column> tableColumns = table.getColumns();
        String[] columnNames = new String[tableColumns.size()];
        byte[] columnTypes = new byte[columnNames.length];
        this.fillColumnNamesAndTypes(tableColumns, columnNames, columnTypes);
        ArrayList<Job<Frame>> parseJobs = new ArrayList<Job<Frame>>(partitions.size());
        for (int i = 0; i < partitions.size(); ++i) {
            String partitionKey = "_" + targetFrame + "_part_" + i;
            Job<Frame> job = this.parsePartition(partitionColumns, partitions.get(i), partitionKey, columnNames, columnTypes);
            if (job == null) continue;
            parseJobs.add(job);
        }
        if (parseJobs.isEmpty()) {
            this.throwTableEmpty(table);
        }
        Job job = new Job(Key.make((String)targetFrame), Frame.class.getName(), "ImportHiveTable");
        PartitionFrameJoiner joiner = new PartitionFrameJoiner((Job<Frame>)job, table, partitions, targetFrame, parseJobs);
        return job.start((H2O.H2OCountedCompleter)joiner, (long)(partitions.size() + 1));
    }

    private Job<Frame> parsePartition(List<HiveMetaData.Column> partitionColumns, HiveMetaData.Partition part, String targetFrame, String[] columnNames, byte[] columnTypes) {
        Key[] files = this.importFiles(part.getLocation());
        if (files.length == 0) {
            return null;
        }
        ParseSetup setup = this.guessSetup(files, part);
        setup.setColumnNames(columnNames);
        setup.setColumnTypes(columnTypes);
        setup.setNumberColumns(columnNames.length);
        ParseDataset parse = ParseDataset.parse((Key)Key.make((String)targetFrame), (Key[])files, (boolean)true, (ParseSetup)setup, (boolean)false);
        return parse._job;
    }

    private void fillColumnNamesAndTypes(List<HiveMetaData.Column> columns, String[] columnNames, byte[] columnTypes) {
        for (int i = 0; i < columns.size(); ++i) {
            HiveMetaData.Column col = columns.get(i);
            columnNames[i] = col.getName();
            columnTypes[i] = HiveTableImporterImpl.convertHiveType(col.getType());
        }
    }

    private ParseSetup guessSetup(Key[] keys, HiveMetaData.Storable sd) {
        ParseSetup parseGuess = new ParseSetup();
        parseGuess.setParseType(DefaultParserProviders.GUESS_INFO);
        parseGuess.setSeparator(this.getSeparator(sd));
        parseGuess.setCheckHeader(-1);
        return ParseSetup.guessSetup((Key[])keys, (ParseSetup)parseGuess);
    }

    private Key[] stringsToKeys(List<String> strings) {
        Key[] keys = new Key[strings.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = Key.make((String)strings.get(i));
        }
        return keys;
    }

    private Key[] importFiles(String path) {
        ArrayList files = new ArrayList();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList fails = new ArrayList();
        ArrayList dels = new ArrayList();
        H2O.getPM().importFiles(path, null, files, keys, fails, dels);
        if (!fails.isEmpty()) {
            throw new RuntimeException("Failed to import some files: " + fails.toString());
        }
        return this.stringsToKeys(keys);
    }

    private Set<String> parseColumnFilter(String filter) {
        HashSet<String> columnNames = new HashSet<String>();
        for (String colName : filter.split(",")) {
            columnNames.add(colName.trim());
        }
        return columnNames;
    }

    static byte convertHiveType(String hiveType) {
        return HiveTableImporterImpl.convertHiveType(hiveType, false);
    }

    static byte convertHiveType(String hiveType, boolean strict) {
        String sanitized;
        switch (sanitized = HiveTableImporterImpl.sanitizeHiveType(hiveType)) {
            case "tinyint": 
            case "smallint": 
            case "int": 
            case "bigint": 
            case "integer": 
            case "float": 
            case "double": 
            case "double precision": 
            case "decimal": 
            case "numeric": {
                return 3;
            }
            case "timestamp": 
            case "data": {
                return 5;
            }
            case "interval": 
            case "string": 
            case "varchar": 
            case "char": 
            case "binary": {
                return 2;
            }
            case "boolean": {
                return 4;
            }
        }
        if (strict) {
            throw new IllegalArgumentException("Unsupported column type: " + hiveType);
        }
        LOG.warn((Object)("Unrecognized Hive type '" + hiveType + "'. Using String type instead."));
        return 2;
    }

    static String sanitizeHiveType(String type) {
        int paramIdx = type.indexOf(40);
        if (paramIdx >= 0) {
            type = type.substring(0, paramIdx);
        }
        return type.trim().toLowerCase();
    }
}

