/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import water.hive.DelegationTokenPrinter;
import water.hive.HiveTokenGenerator;
import water.hive.ImpersonationUtils;

public class GenerateHiveToken
extends Configured
implements Tool {
    private String runAsUser = null;
    private String principal = null;
    private String keytabPath = null;
    private String hiveJdbcUrlPattern = null;
    private String hiveHost = null;
    private String hivePrincipal = null;
    private String tokenFile = null;

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new GenerateHiveToken(), (String[])args);
        System.exit(exitCode);
    }

    private void usage() {
        System.out.println("Usage:");
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.equals("-run_as_user")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.runAsUser = args[i];
                continue;
            }
            if (s.equals("-principal")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.principal = args[i];
                continue;
            }
            if (s.equals("-keytab")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.keytabPath = args[i];
                continue;
            }
            if (s.equals("-hiveJdbcUrlPattern")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.hiveJdbcUrlPattern = args[i];
                continue;
            }
            if (s.equals("-hiveHost")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.hiveHost = args[i];
                continue;
            }
            if (s.equals("-hivePrincipal")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.hivePrincipal = args[i];
                continue;
            }
            if (s.equals("-tokenFile")) {
                if (++i >= args.length) {
                    this.usage();
                }
                this.tokenFile = args[i];
                continue;
            }
            System.err.println("Unrecognized option " + s);
            System.exit(1);
        }
    }

    private void validateArgs() {
        ImpersonationUtils.validateImpersonationArgs(this.principal, this.keytabPath, this.runAsUser, this::error, this::warning);
        if (this.hivePrincipal == null) {
            this.error("hive principal name is required (use the '-hivePrincipal' option)");
        }
        if (this.hiveHost == null && this.hiveJdbcUrlPattern == null) {
            this.error("delegation token generator requires Hive host or JDBC URL to be set (use the '-hiveHost' or '-hiveJdbcUrlPattern' option)");
        }
        if (this.tokenFile == null) {
            this.error("token file path required (use the '-tokenFile' option)");
        }
        if (!HiveTokenGenerator.isHiveDriverPresent()) {
            this.error("Hive JDBC driver not available on class-path");
        }
    }

    public int run(String[] args) throws IOException, InterruptedException {
        this.parseArgs(args);
        this.validateArgs();
        ImpersonationUtils.impersonate(this.getConf(), this.principal, this.keytabPath, this.runAsUser);
        String token = HiveTokenGenerator.getHiveDelegationTokenIfHivePresent(this.hiveJdbcUrlPattern, this.hiveHost, this.hivePrincipal);
        if (token != null) {
            DelegationTokenPrinter.printToken(token);
            System.out.println("Token generated, writing into file " + this.tokenFile);
            try (PrintWriter pw = new PrintWriter(this.tokenFile);){
                pw.print(token);
            }
            return 0;
        }
        System.out.println("No token generated.");
        return 1;
    }

    private void error(String s) {
        System.err.printf("\nERROR: %s\n\n", s);
        this.usage();
    }

    private void warning(String s) {
        System.err.printf("\nWARNING: %s\n\n", s);
    }
}

