/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

public class DelegationTokenPrinter {
    public static void printToken(String tokenString) {
        Objects.requireNonNull(tokenString);
        try {
            Token token = new Token();
            token.decodeFromUrlString(tokenString);
            PrintingDelegationTokenIdentifier identifier = new PrintingDelegationTokenIdentifier();
            identifier.readFields(new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
            System.out.println("token.kind: " + token.getKind() + ", token.service: " + token.getService() + ", id.owner: " + identifier.getOwner() + ", id.renewer: " + identifier.getRenewer() + ", id.realUser: " + identifier.getRealUser() + ", id.issueDate: " + identifier.getIssueDate() + " (" + new Date(identifier.getIssueDate()) + "), id.maxDate: " + identifier.getMaxDate() + " (" + new Date(identifier.getMaxDate()) + "), id.validity: " + (identifier.getMaxDate() - System.currentTimeMillis()) / 3600000L + " hours");
        }
        catch (IOException e) {
            System.out.println("Failed to decode token, no debug information will be displayed, cause:" + e.getMessage());
        }
    }

    private static class PrintingDelegationTokenIdentifier
    extends AbstractDelegationTokenIdentifier {
        private PrintingDelegationTokenIdentifier() {
        }

        public Text getKind() {
            return new Text("PRINT");
        }
    }
}

