/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import water.hive.HiveMetaData;
import water.hive.HiveTableImporterImpl;

public class DirectHiveMetadata
implements HiveMetaData {
    private final String database;

    public DirectHiveMetadata(String database) {
        this.database = database == null || database.isEmpty() ? "default" : database;
    }

    @Override
    public HiveMetaData.Table getTable(String tableName) throws TException {
        Configuration conf = new Configuration();
        HiveConf hiveConf = new HiveConf(conf, HiveTableImporterImpl.class);
        HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
        Table table = client.getTable(this.database, tableName);
        List partitions = client.listPartitions(this.database, tableName, (short)Short.MAX_VALUE);
        return new HiveTable(table, partitions);
    }

    static class HiveTable
    implements HiveMetaData.Table {
        private final Table table;
        private final List<HiveMetaData.Partition> partitions;
        private final List<HiveMetaData.Column> columns;
        private final List<HiveMetaData.Column> partitionKeys;

        HiveTable(Table table, List<Partition> parts) {
            this.table = table;
            this.partitions = parts.stream().map(HivePartition::new).collect(Collectors.toList());
            this.columns = table.getSd().getCols().stream().map(HiveColumn::new).collect(Collectors.toList());
            this.partitionKeys = table.getPartitionKeys().stream().map(HiveColumn::new).collect(Collectors.toList());
        }

        @Override
        public String getName() {
            return this.table.getTableName();
        }

        @Override
        public boolean hasPartitions() {
            return !this.partitions.isEmpty();
        }

        @Override
        public List<HiveMetaData.Partition> getPartitions() {
            return this.partitions;
        }

        @Override
        public List<HiveMetaData.Column> getColumns() {
            return this.columns;
        }

        @Override
        public Map<String, String> getSerDeParams() {
            return this.table.getSd().getSerdeInfo().getParameters();
        }

        @Override
        public String getLocation() {
            return this.table.getSd().getLocation();
        }

        @Override
        public String getSerializationLib() {
            return this.table.getSd().getSerdeInfo().getSerializationLib();
        }

        @Override
        public String getInputFormat() {
            return this.table.getSd().getInputFormat();
        }

        @Override
        public List<HiveMetaData.Column> getPartitionKeys() {
            return this.partitionKeys;
        }
    }

    static class HiveColumn
    implements HiveMetaData.Column {
        private final FieldSchema column;

        HiveColumn(FieldSchema column) {
            this.column = column;
        }

        @Override
        public String getName() {
            return this.column.getName();
        }

        @Override
        public String getType() {
            return this.column.getType();
        }
    }

    static class HivePartition
    implements HiveMetaData.Partition {
        private final Partition partition;

        HivePartition(Partition partition) {
            this.partition = partition;
        }

        @Override
        public List<String> getValues() {
            return this.partition.getValues();
        }

        @Override
        public Map<String, String> getSerDeParams() {
            return this.partition.getSd().getSerdeInfo().getParameters();
        }

        @Override
        public String getLocation() {
            return this.partition.getSd().getLocation();
        }

        @Override
        public String getSerializationLib() {
            return this.partition.getSd().getSerdeInfo().getSerializationLib();
        }

        @Override
        public String getInputFormat() {
            return this.partition.getSd().getInputFormat();
        }
    }
}

