/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

public class ImpersonationUtils {
    public static void validateImpersonationArgs(String principal, String keytabPath, String runAsUser, Callback error, Callback warn) {
        if (principal != null || keytabPath != null) {
            if (principal == null) {
                error.call("keytab requires a valid principal (use the '-principal' option)");
            }
            if (keytabPath == null) {
                error.call("principal requires a valid keytab path (use the '-keytab' option)");
            }
            if (runAsUser != null) {
                warn.call("will attempt secure impersonation with user from '-run_as_user', " + runAsUser);
            }
        }
    }

    public static void impersonate(Configuration conf, String principal, String keytabPath, String runAsUser) throws IOException {
        if (principal != null && keytabPath != null) {
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabPath);
            if (runAsUser != null) {
                System.out.println("Attempting to securely impersonate user, " + runAsUser);
                UserGroupInformation currentEffUser = UserGroupInformation.getLoginUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)runAsUser, (UserGroupInformation)currentEffUser);
                UserGroupInformation.setLoginUser((UserGroupInformation)proxyUser);
            }
        } else if (runAsUser != null) {
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)runAsUser));
        }
    }

    public static interface Callback {
        public void call(String var1);
    }
}

