/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import water.H2O;
import water.Key;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.persist.PersistHdfs;
import water.util.PrettyPrint;

public class FrameParquetWriter {
    public void write(Frame frame, String fileName) throws IOException {
        Schema schema = this.makeSchema(frame);
        try (ParquetWriter<GenericRecord> writer = this.openWriter(fileName, schema);){
            Chunk[] chunks = new Chunk[frame.numCols()];
            BufferedString tmpStr = new BufferedString();
            for (int cidx = 0; cidx < frame.anyVec().nChunks(); ++cidx) {
                int col;
                for (col = 0; col < frame.numCols(); ++col) {
                    chunks[col] = frame.vec(col).chunkForChunkIdx(cidx);
                }
                for (int crow = 0; crow < chunks[0].len(); ++crow) {
                    GenericRecordBuilder builder = new GenericRecordBuilder(schema);
                    for (int col2 = 0; col2 < frame.numCols(); ++col2) {
                        builder.set(frame.name(col2), this.getValue(chunks[col2], crow, tmpStr));
                    }
                    writer.write((Object)builder.build());
                }
                for (col = 0; col < frame.numCols(); ++col) {
                    Key chunkKey = chunks[col].vec().chunkKey(cidx);
                    if (chunkKey.home()) continue;
                    H2O.raw_remove((Key)chunkKey);
                }
            }
        }
    }

    private Object getValue(Chunk chunk, int crow, BufferedString tmpStr) {
        Vec v = chunk.vec();
        if (!chunk.isNA(crow)) {
            if (v.isCategorical()) {
                return chunk.vec().domain()[(int)chunk.at8(crow)];
            }
            if (v.isUUID()) {
                return PrettyPrint.UUID((long)chunk.at16l(crow), (long)chunk.at16h(crow));
            }
            if (v.isInt()) {
                return chunk.at8(crow);
            }
            if (v.isString()) {
                return chunk.atStr(tmpStr, crow).toString();
            }
            return chunk.atd(crow);
        }
        return null;
    }

    private ParquetWriter<GenericRecord> openWriter(String fileName, Schema schema) throws IOException {
        return ((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(fileName)).withSchema(schema).withConf(PersistHdfs.CONF)).build();
    }

    private Schema makeSchema(Frame frame) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (int cidx = 0; cidx < frame.numCols(); ++cidx) {
            fields.add(new Schema.Field(frame.name(cidx), this.getColumnType(frame.vec(cidx)), null, null));
        }
        Schema schema = Schema.createRecord((String)"h2o_frame", null, null, (boolean)false);
        schema.setFields(fields);
        return schema;
    }

    private Schema getColumnType(Vec v) {
        Schema type = v.isCategorical() || v.isUUID() || v.isString() ? Schema.create((Schema.Type)Schema.Type.STRING) : (v.isInt() ? Schema.create((Schema.Type)Schema.Type.LONG) : Schema.create((Schema.Type)Schema.Type.DOUBLE));
        return Schema.createUnion(Arrays.asList(type, Schema.create((Schema.Type)Schema.Type.NULL)));
    }
}

