package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit.*;
import retrofit.http.*;

public interface Models {
    @GET("/3/Models/{modelid}")
    ModelsV3 fetch(ModelKeyV3 model_id);

    @GET("/3/Models")
    ModelsV3 list();

    @DELETE("/3/Models/{modelid}")
    ModelsV3 delete(ModelKeyV3 model_id);

    @DELETE("/3/Models")
    ModelsV3 deleteAll();

    @GET("/3/Models.java/{modelid}/preview")
    StreamingSchema fetchPreview(ModelKeyV3 model_id);

    @GET("/3/Models.java/(?<modelid>.*?)(\\.java)?")
    StreamingSchema fetchJavaCode(ModelKeyV3 model_id);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/99/Models.bin/{modelid}")
    ModelsV3 importModel(ModelImportV3 parms);

    @GET("/99/Models.bin/{modelid}")
    ModelExportV3 exportModel(ModelKeyV3 model_id);
}
