package water.bindings.pojos;

public class FieldMetadataV3 extends FieldMetadataBase {
    /** Field name in the Schema */
    public String name;

    /** Type for this field */
    public String type;

    /** Type for this field is itself a Schema. */
    public boolean is_schema;

    /** Schema name for this field, if it is_schema, or the name of the enum, if it's an enum. */
    public String schema_name;

    /** Value for this field */
    public Object value;

    /** A short help description to appear alongside the field in a UI */
    public String help;

    /** The label that should be displayed for the field if the name is insufficient */
    public String label;

    /** Is this field required, or is the default value generally sufficient? */
    public boolean required;

    /** How important is this field?  The web UI uses the level to do a slow reveal of the parameters */
    public Level level;

    /** Is this field an input, output or inout? */
    public Direction direction;

    /** Is the field gridable (i.e., it can be used in grid call) */
    public boolean is_gridable;

    /** For enum-type fields the allowed values are specified using the values annotation;  this is used in UIs to tell the user the allowed values, and for validation */
    public String[] values;

    /** Should this field be rendered in the JSON representation? */
    public boolean json;

    /** For Vec-type fields this is the set of other Vec-type fields which must contain mutually exclusive values; for example, for a SupervisedModel the response_column must be mutually exclusive with the weights_column */
    public String[] is_member_of_frames;

    /** For Vec-type fields this is the set of Frame-type fields which must contain the named column; for example, for a SupervisedModel the response_column must be in both the training_frame and (if it's set) the validation_frame */
    public String[] is_mutually_exclusive_with;
}
