package water.bindings.pojos;

public class GLRMParametersV99 extends ModelParametersSchema {
    /** Transformation of training data */
    public TransformType transform;

    /** Rank of matrix approximation */
    public int k;

    /** Numeric loss function */
    public Loss loss;

    /** Enum loss function */
    public Loss multi_loss;

    /** Loss function by column (override) */
    public Loss[] loss_by_col;

    /** Loss function by column index (override) */
    public int[] loss_by_col_idx;

    /** Length of period (only used with periodic loss function) */
    public int period;

    /** Regularization function for X matrix */
    public Regularizer regularization_x;

    /** Regularization function for Y matrix */
    public Regularizer regularization_y;

    /** Regularization weight on X matrix */
    public double gamma_x;

    /** Regularization weight on Y matrix */
    public double gamma_y;

    /** Maximum number of iterations */
    public int max_iterations;

    /** Initial step size */
    public double init_step_size;

    /** Minimum step size */
    public double min_step_size;

    /** RNG seed for initialization */
    public long seed;

    /** Initialization mode */
    public Initialization init;

    /** User-specified initial Y */
    public String user_points;

    /** Frame key to save resulting X */
    public String loading_name;

    /** Recover singular values and eigenvectors of XY */
    public boolean recover_svd;

    /** Destination id for this model; auto-generated if not specified */
    public String model_id;

    /** Training frame */
    public String training_frame;

    /** Validation frame */
    public String validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public String checkpoint;
}
