package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit.*;
import retrofit.http.*;

public interface ModelBuilders {
    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/{algo}/model_id")
    ModelIdV3 calcModelId(ModelBuildersV3 parms);

    @GET("/3/ModelBuilders/{algo}")
    ModelBuildersV3 fetch(String algo);

    @GET("/3/ModelBuilders")
    ModelBuildersV3 list();

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/gbm")
    GBMV3 train(GBMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/gbm/parameters")
    GBMV3 validate_parameters(GBMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/drf")
    DRFV3 train(DRFV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/drf/parameters")
    DRFV3 validate_parameters(DRFV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/kmeans")
    KMeansV3 train(KMeansV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/kmeans/parameters")
    KMeansV3 validate_parameters(KMeansV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/deeplearning")
    DeepLearningV3 train(DeepLearningV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/deeplearning/parameters")
    DeepLearningV3 validate_parameters(DeepLearningV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/glm")
    GLMV3 train(GLMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/glm/parameters")
    GLMV3 validate_parameters(GLMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/naivebayes")
    NaiveBayesV3 train(NaiveBayesV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/naivebayes/parameters")
    NaiveBayesV3 validate_parameters(NaiveBayesV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/pca")
    PCAV3 train(PCAV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/pca/parameters")
    PCAV3 validate_parameters(PCAV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/glrm")
    GLRMV3 train(GLRMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelBuilders/glrm/parameters")
    GLRMV3 validate_parameters(GLRMV3 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/99/ModelBuilders/svd")
    SVDV99 train(SVDV99 parms);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/99/ModelBuilders/svd/parameters")
    SVDV99 validate_parameters(SVDV99 parms);
}
