package water.bindings.pojos;

public class DeepLearningParametersV3 extends ModelParametersSchema {
    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** If enabled, override the final model with the best model found during training */
    public boolean overwrite_with_best_model;

    /** Auto-Encoder */
    public boolean autoencoder;

    /** Use all factor levels of categorical variables. Otherwise, the first factor level is omitted (without loss of accuracy). Useful for variable importances and auto-enabled for autoencoder. */
    public boolean use_all_factor_levels;

    /** Activation function */
    public Activation activation;

    /** Hidden layer sizes (e.g. 100,100). */
    public int[] hidden;

    /** How many times the dataset should be iterated (streamed), can be fractional */
    public double epochs;

    /** Number of training samples (globally) per MapReduce iteration. Special values are 0: one epoch, -1: all available data (e.g., replicated training data), -2: automatic */
    public long train_samples_per_iteration;

    /** Target ratio of communication overhead to computation. Only for multi-node operation and train_samples_per_iteration=-2 (auto-tuning) */
    public double target_ratio_comm_to_comp;

    /** Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded */
    public long seed;

    /** Adaptive learning rate */
    public boolean adaptive_rate;

    /** Adaptive learning rate time decay factor (similarity to prior updates) */
    public double rho;

    /** Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress) */
    public double epsilon;

    /** Learning rate (higher => less stable, lower => slower convergence) */
    public double rate;

    /** Learning rate annealing: rate / (1 + rate_annealing * samples) */
    public double rate_annealing;

    /** Learning rate decay factor between layers (N-th layer: rate*alpha^(N-1)) */
    public double rate_decay;

    /** Initial momentum at the beginning of training (try 0.5) */
    public double momentum_start;

    /** Number of training samples for which momentum increases */
    public double momentum_ramp;

    /** Final momentum after the ramp is over (try 0.99) */
    public double momentum_stable;

    /** Use Nesterov accelerated gradient (recommended) */
    public boolean nesterov_accelerated_gradient;

    /** Input layer dropout ratio (can improve generalization, try 0.1 or 0.2) */
    public double input_dropout_ratio;

    /** Hidden layer dropout ratios (can improve generalization), specify one value per hidden layer, defaults to 0.5 */
    public double[] hidden_dropout_ratios;

    /** L1 regularization (can add stability and improve generalization, causes many weights to become 0) */
    public double l1;

    /** L2 regularization (can add stability and improve generalization, causes many weights to be small */
    public double l2;

    /** Constraint for squared sum of incoming weights per unit (e.g. for Rectifier) */
    public float max_w2;

    /** Initial Weight Distribution */
    public InitialWeightDistribution initial_weight_distribution;

    /** Uniform: -value...value, Normal: stddev) */
    public double initial_weight_scale;

    /** Loss function */
    public Loss loss;

    /** Distribution function */
    public Family distribution;

    /** Tweedie Power */
    public double tweedie_power;

    /** Shortest time interval (in secs) between model scoring */
    public double score_interval;

    /** Number of training set samples for scoring (0 for all) */
    public long score_training_samples;

    /** Number of validation set samples for scoring (0 for all) */
    public long score_validation_samples;

    /** Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring). */
    public double score_duty_cycle;

    /** Stopping criterion for classification error fraction on training data (-1 to disable) */
    public double classification_stop;

    /** Stopping criterion for regression error (MSE) on training data (-1 to disable) */
    public double regression_stop;

    /** Enable quiet mode for less output to standard output */
    public boolean quiet_mode;

    /** Method used to sample validation dataset for scoring */
    public ClassSamplingMethod score_validation_sampling;

    /** Enable diagnostics for hidden layers */
    public boolean diagnostics;

    /** Compute variable importances for input features (Gedeon method) - can be slow for large networks */
    public boolean variable_importances;

    /** Enable fast mode (minor approximation in back-propagation) */
    public boolean fast_mode;

    /** Force extra load balancing to increase training speed for small datasets (to keep all cores busy) */
    public boolean force_load_balance;

    /** Replicate the entire training dataset onto every node for faster training on small datasets */
    public boolean replicate_training_data;

    /** Run on a single node for fine-tuning of model parameters */
    public boolean single_node_mode;

    /** Enable shuffling of training data (recommended if training data is replicated and train_samples_per_iteration is close to #nodes x #rows, of if using balance_classes) */
    public boolean shuffle_training_data;

    /** Handling of missing values. Either Skip or MeanImputation. */
    public MissingValuesHandling missing_values_handling;

    /** Sparse data handling (more efficient for data with lots of 0 values). */
    public boolean sparse;

    /** Use a column major weight matrix for input layer. Can speed up forward propagation, but might slow down backpropagation (Deprecated). */
    public boolean col_major;

    /** Average activation for sparse auto-encoder (Experimental) */
    public double average_activation;

    /** Sparsity regularization (Experimental) */
    public double sparsity_beta;

    /** Max. number of categorical features, enforced via hashing (Experimental) */
    public int max_categorical_features;

    /** Force reproducibility on small data (will be slow - only uses 1 thread) */
    public boolean reproducible;

    /** Whether to export Neural Network weights and biases to H2O Frames */
    public boolean export_weights_and_biases;

    /** Elastic averaging between compute nodes can improve distributed model convergence (Experimental) */
    public boolean elastic_averaging;

    /** Elastic averaging moving rate (only if elastic averaging is enabled). */
    public double elastic_averaging_moving_rate;

    /** Elastic averaging regularization strength (only if elastic averaging is enabled). */
    public double elastic_averaging_regularization;

    /** Destination id for this model; auto-generated if not specified */
    public String model_id;

    /** Training frame */
    public String training_frame;

    /** Validation frame */
    public String validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public String checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public StoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;
}
