package water.bindings.pojos;

public class GLMParametersV3 extends ModelParametersSchema {
    /** Family. Use binomial for classification with logistic regression, others are for regression problems. */
    public Family family;

    /** Tweedie variance power */
    public double tweedie_variance_power;

    /** Tweedie link power */
    public double tweedie_link_power;

    /** AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns. Coordinate descent is experimental (beta). */
    public Solver solver;

    /** distribution of regularization between L1 and L2. */
    public double[] alpha;

    /** regularization strength */
    public double[] lambda;

    /** use lambda search starting at lambda max, given lambda is then interpreted as lambda min */
    public boolean lambda_search;

    /** number of lambdas to be used in a search */
    public int nlambdas;

    /** Standardize numeric columns to have zero mean and unit variance */
    public boolean standardize;

    /** Restrict coefficients (not intercept) to be non-negative */
    public boolean non_negative;

    /** Maximum number of iterations */
    public int max_iterations;

    /** converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver  */
    public double beta_epsilon;

    /** converge if  objective value changes less than this */
    public double objective_epsilon;

    /** converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver */
    public double gradient_epsilon;

    /** likelihood divider in objective value computation, default is 1/nobs */
    public double obj_reg;

    /**  */
    public Link link;

    /** include constant term in the model */
    public boolean intercept;

    /** prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean of response does not reflect reality. */
    public double prior;

    /** min lambda used in lambda search, specified as a ratio of lambda_max */
    public double lambda_min_ratio;

    /** beta constraints */
    public String beta_constraints;

    /** Maximum number of active predictors during computation. Use as a stopping criterium to prevent expensive model building with many predictors. */
    public int max_active_predictors;

    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** Destination id for this model; auto-generated if not specified */
    public String model_id;

    /** Training frame */
    public String training_frame;

    /** Validation frame */
    public String validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public String checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public StoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;
}
