package water.bindings.pojos;

public class InteractionV3 extends JobV3 {
    /** Input data frame */
    public String source_frame;

    /** Factor columns */
    public String[] factor_columns;

    /** Whether to create pairwise quadratic interactions between factors (otherwise create one higher-order interaction). Only applicable if there are 3 or more factors. */
    public boolean pairwise;

    /** Max. number of factor levels in pair-wise interaction terms (if enforced, one extra catch-all factor will be made) */
    public int max_factors;

    /** Min. occurrence threshold for factor levels in pair-wise interaction terms */
    public int min_occurrence;

    /** Job Key */
    public String key;

    /** Job description */
    public String description;

    /** job status */
    public String status;

    /** progress, from 0 to 1 */
    public float progress;

    /** current progress status description */
    public String progress_msg;

    /** Start time */
    public long start_time;

    /** Runtime in milliseconds */
    public long msec;

    /** destination key */
    public String dest;

    /** exception */
    public String exception;

    /** Info, warning and error messages; NOTE: can be appended to while the Job is running */
    public ValidationMessageV3[] messages;

    /** Count of error messages */
    public int error_count;
}
