package water.bindings.pojos;

public class NodeV3 extends Schema {
    /** IP */
    public String h2o;

    /** IP address and port in the form a.b.c.d:e */
    public String ip_port;

    /** (now-last_ping)<HeartbeatThread.TIMEOUT */
    public boolean healthy;

    /** Time (in msec) of last ping */
    public long last_ping;

    /** System load; average #runnables/#cores */
    public float sys_load;

    /** Linpack GFlops */
    public double gflops;

    /** Memory Bandwidth */
    public double mem_bw;

    /** Data on Node (memory or disk) */
    public long total_value_size;

    /** Data on Node (memory only) */
    public long mem_value_size;

    /** #local keys */
    public int num_keys;

    /** Free heap */
    public long free_mem;

    /** Total heap */
    public long tot_mem;

    /** Max heap */
    public long max_mem;

    /** Free disk */
    public long free_disk;

    /** Max disk */
    public long max_disk;

    /** Active Remote Procedure Calls */
    public int rpcs_active;

    /** F/J Thread count, by priority */
    public short[] fjthrds;

    /** F/J Task count, by priority */
    public short[] fjqueue;

    /** Open TCP connections */
    public int tcps_active;

    /** Open File Descripters */
    public int open_fds;

    /** num_cpus */
    public int num_cpus;

    /** cpus_allowed */
    public int cpus_allowed;

    /** nthreads */
    public int nthreads;

    /** System CPU percentage used by this H2O process in last interval */
    public int my_cpu_pct;

    /** System CPU percentage used by everything in last interval */
    public int sys_cpu_pct;

    /** PID */
    public String pid;
}
