package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit.*;
import retrofit.http.*;

public interface Metadata {
    @GET("/3/Metadata/endpoints/(?<num>[0-9]+)")
    MetadataV3 fetchRoute(int num);

    @GET("/3/Metadata/endpoints/{path}")
    MetadataV3 fetchRoute(String path);

    @GET("/3/Metadata/endpoints")
    MetadataV3 listRoutes();

    @GET("/3/Metadata/schemaclasses/{classname}")
    MetadataV3 fetchSchemaMetadataByClass(String classname);

    @GET("/3/Metadata/schemas/{schemaname}")
    MetadataV3 fetchSchemaMetadata(String schemaname);

    @GET("/3/Metadata/schemas")
    MetadataV3 listSchemas();
}
