package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit.*;
import retrofit.http.*;

public interface ModelMetrics {
    @GET("/3/ModelMetrics/models/{model}/frames/{frame}")
    ModelMetricsListSchemaV3 fetch(ModelKeyV3 model, FrameKeyV3 frame);

    @DELETE("/3/ModelMetrics/models/{model}/frames/{frame}")
    ModelMetricsListSchemaV3 delete(ModelKeyV3 model, FrameKeyV3 frame);

    @GET("/3/ModelMetrics/models/{model}")
    ModelMetricsListSchemaV3 fetch(ModelKeyV3 model);

    @GET("/3/ModelMetrics/frames/{frame}/models/{model}")
    ModelMetricsListSchemaV3 fetch(FrameKeyV3 frame, ModelKeyV3 model);

    @DELETE("/3/ModelMetrics/frames/{frame}/models/{model}")
    ModelMetricsListSchemaV3 delete(FrameKeyV3 frame, ModelKeyV3 model);

    @GET("/3/ModelMetrics/frames/{frame}")
    ModelMetricsListSchemaV3 fetch(FrameKeyV3 frame);

    @GET("/3/ModelMetrics")
    ModelMetricsListSchemaV3 fetch();

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/ModelMetrics/models/{model}/frames/{frame}")
    ModelMetricsListSchemaV3 score(ModelMetricsListSchemaV3 parms);
}
