package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit.*;
import retrofit.http.*;

public interface NodePersistentStorage {
    @GET("/3/NodePersistentStorage/categories/{category}/names/{name}/exists")
    NodePersistentStorageV3 exists(String category, String name);

    @GET("/3/NodePersistentStorage/categories/{category}/exists")
    NodePersistentStorageV3 exists(String category);

    @GET("/3/NodePersistentStorage/configured")
    NodePersistentStorageV3 configured();

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/NodePersistentStorage/{category}/{name}")
    NodePersistentStorageV3 put_with_name(NodePersistentStorageV3 parms);

    @GET("/3/NodePersistentStorage/{category}/{name}")
    NodePersistentStorageV3 get_as_string(String category, String name);

    @DELETE("/3/NodePersistentStorage/{category}/{name}")
    NodePersistentStorageV3 delete(String category, String name);

    @Headers("Content-Type: application/x-www-form-urlencoded; charset=UTF-8")
    @POST("/3/NodePersistentStorage/{category}")
    NodePersistentStorageV3 put(NodePersistentStorageV3 parms);

    @GET("/3/NodePersistentStorage/{category}")
    NodePersistentStorageV3 list(String category);
}
