package water.bindings.pojos;

public class GLRMParametersV3 extends ModelParametersSchema {
    /** Transformation of training data */
    public TransformType transform;

    /** Rank of matrix approximation */
    public int k;

    /** Numeric loss function */
    public Loss loss;

    /** Categorical loss function */
    public Loss multi_loss;

    /** Loss function by column (override) */
    public Loss[] loss_by_col;

    /** Loss function by column index (override) */
    public int[] loss_by_col_idx;

    /** Length of period (only used with periodic loss function) */
    public int period;

    /** Regularization function for X matrix */
    public Regularizer regularization_x;

    /** Regularization function for Y matrix */
    public Regularizer regularization_y;

    /** Regularization weight on X matrix */
    public double gamma_x;

    /** Regularization weight on Y matrix */
    public double gamma_y;

    /** Maximum number of iterations */
    public int max_iterations;

    /** Maximum number of updates */
    public int max_updates;

    /** Initial step size */
    public double init_step_size;

    /** Minimum step size */
    public double min_step_size;

    /** RNG seed for initialization */
    public long seed;

    /** Initialization mode */
    public Initialization init;

    /** Method for computing SVD during initialization (Caution: Power and Randomized are currently experimental and unstable) */
    public Method svd_method;

    /** User-specified initial Y */
    public String user_y;

    /** User-specified initial X */
    public String user_x;

    /** Frame key to save resulting X */
    public String loading_name;

    /** Expand categorical columns in user-specified initial Y */
    public boolean expand_user_y;

    /** Reconstruct original training data by reversing transform */
    public boolean impute_original;

    /** Recover singular values and eigenvectors of XY */
    public boolean recover_svd;

    /** Destination id for this model; auto-generated if not specified */
    public String model_id;

    /** Training frame */
    public String training_frame;

    /** Validation frame */
    public String validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Allow parallel training of cross-validation models */
    public boolean parallelize_cross_validation;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public String checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Maximum allowed runtime in seconds for model training. Use 0 to disable. For cross-validation or grid searches, this limit applies to all sub-models. */
    public double max_runtime_secs;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public StoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;
}
