package water.bindings.pojos;

public class CreateFrameV3 extends RequestSchema {
    /** Job Key */
    public String key;

    /** destination key */
    public String dest;

    /** Number of rows */
    public long rows;

    /** Number of data columns (in addition to the first response column) */
    public int cols;

    /** Random number seed */
    public long seed;

    /** Whether frame should be randomized */
    public boolean randomize;

    /** Constant value (for randomize=false) */
    public long value;

    /** Range for real variables (-range ... range) */
    public long real_range;

    /** Fraction of categorical columns (for randomize=true) */
    public double categorical_fraction;

    /** Factor levels for categorical variables */
    public int factors;

    /** Fraction of integer columns (for randomize=true) */
    public double integer_fraction;

    /** Range for integer variables (-range ... range) */
    public long integer_range;

    /** Fraction of binary columns (for randomize=true) */
    public double binary_fraction;

    /** Fraction of 1's in binary columns */
    public double binary_ones_fraction;

    /** Fraction of missing values */
    public double missing_fraction;

    /** Number of factor levels of the first column (1=real, 2=binomial, N=multinomial) */
    public int response_factors;

    /** Whether an additional response column should be generated */
    public boolean has_response;

    /** Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" */
    public String _exclude_fields;
}
