package water.bindings.pojos;

import java.util.Map;

public class DeepLearningModelOutputV3 extends ModelOutputSchema {
    /** Frame keys for weight matrices */
    public String[] weights;

    /** Frame keys for bias vectors */
    public String[] biases;

    /** Normalization/Standardization multipliers for numeric predictors */
    public double[] normmul;

    /** Normalization/Standardization offsets for numeric predictors */
    public double[] normsub;

    /** Normalization/Standardization multipliers for numeric response */
    public double[] normrespmul;

    /** Normalization/Standardization offsets for numeric response */
    public double[] normrespsub;

    /** Categorical offsets for one-hot encoding */
    public int[] catoffsets;

    /** Variable Importances */
    public TwoDimTableV3 variable_importances;

    /** Column names */
    public String[] names;

    /** Domains for categorical columns */
    public String[][] domains;

    /** Cross-validation models (model ids) */
    public String[] cross_validation_models;

    /** Cross-validation predictions (frame ids) */
    public String[] cross_validation_predictions;

    /** Category of the model (e.g., Binomial) */
    public ModelCategory model_category;

    /** Model summary */
    public TwoDimTableV3 model_summary;

    /** Scoring history */
    public TwoDimTableV3 scoring_history;

    /** Training data model metrics */
    public ModelMetricsBase training_metrics;

    /** Validation data model metrics */
    public ModelMetricsBase validation_metrics;

    /** Cross-validation model metrics */
    public ModelMetricsBase cross_validation_metrics;

    /** Job status */
    public String status;

    /** Start time in milliseconds */
    public long start_time;

    /** End time in milliseconds */
    public long end_time;

    /** Runtime in milliseconds */
    public long run_time;

    /** Help information for output fields */
    public Map<String,String> help;
}
