package water.bindings.pojos;

public class InteractionV3 extends RequestSchema {
    /** destination key */
    public String dest;

    /** Input data frame */
    public String source_frame;

    /** Factor columns */
    public String[] factor_columns;

    /** Whether to create pairwise quadratic interactions between factors (otherwise create one higher-order interaction). Only applicable if there are 3 or more factors. */
    public boolean pairwise;

    /** Max. number of factor levels in pair-wise interaction terms (if enforced, one extra catch-all factor will be made) */
    public int max_factors;

    /** Min. occurrence threshold for factor levels in pair-wise interaction terms */
    public int min_occurrence;

    /** Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" */
    public String _exclude_fields;
}
