package water.bindings.pojos;

public class NodeV3 extends Schema {
    /** IP */
    public String h2o;

    /** IP address and port in the form a.b.c.d:e */
    public String ip_port;

    /** (now-last_ping)<HeartbeatThread.TIMEOUT */
    public boolean healthy;

    /** Time (in msec) of last ping */
    public long last_ping;

    /** PID */
    public int pid;

    /** num_cpus */
    public int num_cpus;

    /** cpus_allowed */
    public int cpus_allowed;

    /** nthreads */
    public int nthreads;

    /** System load; average #runnables/#cores */
    public float sys_load;

    /** System CPU percentage used by this H2O process in last interval */
    public int my_cpu_pct;

    /** System CPU percentage used by everything in last interval */
    public int sys_cpu_pct;

    /** Data on Node memory */
    public long mem_value_size;

    /** Temp (non Data) memory */
    public long pojo_mem;

    /** Free heap */
    public long free_mem;

    /** Maximum memory size for node */
    public long max_mem;

    /** Size of data on node's disk */
    public long swap_mem;

    /** #local keys */
    public int num_keys;

    /** Free disk */
    public long free_disk;

    /** Max disk */
    public long max_disk;

    /** Active Remote Procedure Calls */
    public int rpcs_active;

    /** F/J Thread count, by priority */
    public short[] fjthrds;

    /** F/J Task count, by priority */
    public short[] fjqueue;

    /** Open TCP connections */
    public int tcps_active;

    /** Open File Descripters */
    public int open_fds;

    /** Linpack GFlops */
    public double gflops;

    /** Memory Bandwidth */
    public double mem_bw;
}
