package water.bindings.pojos;

public class QuantileParametersV3 extends ModelParametersSchema {
    /** Probabilities for quantiles */
    public double[] probs;

    /** How to combine quantiles for even sample sizes */
    public CombineMethod combine_method;

    /** Destination id for this model; auto-generated if not specified */
    public String model_id;

    /** Training frame */
    public String training_frame;

    /** Validation frame */
    public String validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Allow parallel training of cross-validation models */
    public boolean parallelize_cross_validation;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public String checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Maximum allowed runtime in seconds for model training. Use 0 to disable. */
    public double max_runtime_secs;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public StoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;
}
