package water.bindings.pojos;

import java.util.Map;

public class GLRMModelOutputV3 extends ModelOutputSchema {
    /** Iterations executed */
    public int iterations;

    /** Updates executed */
    public int updates;

    /** Objective value */
    public double objective;

    /** Average change in objective value on final iteration */
    public double avg_change_obj;

    /** Final step size */
    public double step_size;

    /** Mapping from lower dimensional k-space to training features */
    public TwoDimTableV3 archetypes;

    /** Singular values of XY matrix */
    public double[] singular_vals;

    /** Eigenvectors of XY matrix */
    public TwoDimTableV3 eigenvectors;

    /** Frame key name for X matrix */
    public String representation_name;

    /** Column names */
    public String[] names;

    /** Domains for categorical columns */
    public String[][] domains;

    /** Cross-validation models (model ids) */
    public String[] cross_validation_models;

    /** Cross-validation predictions (frame ids) */
    public String[] cross_validation_predictions;

    /** Category of the model (e.g., Binomial) */
    public ModelCategory model_category;

    /** Model summary */
    public TwoDimTableV3 model_summary;

    /** Scoring history */
    public TwoDimTableV3 scoring_history;

    /** Training data model metrics */
    public ModelMetricsBase training_metrics;

    /** Validation data model metrics */
    public ModelMetricsBase validation_metrics;

    /** Cross-validation model metrics */
    public ModelMetricsBase cross_validation_metrics;

    /** Job status */
    public String status;

    /** Start time in milliseconds */
    public long start_time;

    /** End time in milliseconds */
    public long end_time;

    /** Runtime in milliseconds */
    public long run_time;

    /** Help information for output fields */
    public Map<String,String> help;
}
