package water.bindings.pojos;

import com.google.gson.Gson;
public class FrameV3 extends FrameBase {
    /** Row offset to display */
    public long row_offset;

    /** Number of rows to display */
    public int row_count;

    /** Column offset to return */
    public int column_offset;

    /** Number of columns to return */
    public int column_count;

    /** Total number of columns in the Frame */
    public int total_column_count;

    /** checksum */
    public long checksum;

    /** Number of rows in the Frame */
    public long rows;

    /** Default percentiles, from 0 to 1 */
    public double[] default_percentiles;

    /** Columns in the Frame */
    public ColV3[] columns;

    /** Compatible models, if requested */
    public String[] compatible_models;

    /** Chunk summary */
    public TwoDimTableV3 chunk_summary;

    /** Distribution summary */
    public TwoDimTableV3 distribution_summary;

    /* INHERITED: Frame ID 
     * public FrameKeyV3 frame_id;
     */

    /* INHERITED: Total data size in bytes 
     * public long byte_size;
     */

    /* INHERITED: Is this Frame raw unparsed data? 
     * public boolean is_text;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
