package water.bindings.pojos;

import com.google.gson.Gson;
public class ModelMetricsBinomialV3 extends ModelMetricsBase {
    /** The R^2 for this scoring run. */
    public double r2;

    /** The logarithmic loss for this scoring run. */
    public double logloss;

    /** The AUC for this scoring run. */
    public double AUC;

    /** The Gini score for this scoring run. */
    public double Gini;

    /** The class labels of the response. */
    public String[] domain;

    /** The Metrics for various thresholds. */
    public TwoDimTableV3 thresholds_and_metric_scores;

    /** The Metrics for various criteria. */
    public TwoDimTableV3 max_criteria_and_metric_scores;

    /** Gains and Lift table. */
    public TwoDimTableV3 gains_lift_table;

    /* INHERITED: The model used for this scoring run. 
     * public ModelKeyV3 model;
     */

    /* INHERITED: The checksum for the model used for this scoring run. 
     * public long model_checksum;
     */

    /* INHERITED: The frame used for this scoring run. 
     * public FrameKeyV3 frame;
     */

    /* INHERITED: The checksum for the frame used for this scoring run. 
     * public long frame_checksum;
     */

    /* INHERITED: Optional description for this scoring run (to note out-of-bag, sampled data, etc.) 
     * public String description;
     */

    /* INHERITED: The category (e.g., Clustering) for the model used for this scoring run. 
     * public ModelCategory model_category;
     */

    /* INHERITED: The time in mS since the epoch for the start of this scoring run. 
     * public long scoring_time;
     */

    /* INHERITED: Predictions Frame. 
     * public FrameV3 predictions;
     */

    /* INHERITED: The Mean Squared Error of the prediction for this scoring run. 
     * public double MSE;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
