package water.bindings.pojos;

import com.google.gson.Gson;
public class ModelParameterSchemaV3 extends Schema {
    /** name in the JSON, e.g. "lambda" */
    public String name;

    /** label in the UI, e.g. "lambda" */
    public String label;

    /** help for the UI, e.g. "regularization multiplier, typically used for foo bar baz etc." */
    public String help;

    /** the field is required */
    public boolean required;

    /** Java type, e.g. "double" */
    public String type;

    /** default value, e.g. 1 */
    public Object default_value;

    /** actual value as set by the user and / or modified by the ModelBuilder, e.g., 10 */
    public Object actual_value;

    /** the importance of the parameter, used by the UI, e.g. "critical", "extended" or "expert" */
    public String level;

    /** list of valid values for use by the front-end */
    public String[] values;

    /** For Vec-type fields this is the set of other Vec-type fields which must contain mutually exclusive values; for example, for a SupervisedModel the response_column must be mutually exclusive with the weights_column */
    public String[] is_member_of_frames;

    /** For Vec-type fields this is the set of Frame-type fields which must contain the named column; for example, for a SupervisedModel the response_column must be in both the training_frame and (if it's set) the validation_frame */
    public String[] is_mutually_exclusive_with;

    /** Parameter can be used in grid call */
    public boolean gridable;

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
