package water.bindings.pojos;

import com.google.gson.Gson;
public class ModelParametersSchema extends Schema {
    /** Destination id for this model; auto-generated if not specified */
    public ModelKeyV3 model_id;

    /** Training frame */
    public FrameKeyV3 training_frame;

    /** Validation frame */
    public FrameKeyV3 validation_frame;

    /** Number of folds for N-fold cross-validation */
    public int nfolds;

    /** Keep cross-validation model predictions */
    public boolean keep_cross_validation_predictions;

    /** Keep cross-validation fold assignment */
    public boolean keep_cross_validation_fold_assignment;

    /** Allow parallel training of cross-validation models */
    public boolean parallelize_cross_validation;

    /** Response column */
    public ColSpecifierV3 response_column;

    /** Column with observation weights */
    public ColSpecifierV3 weights_column;

    /** Offset column */
    public ColSpecifierV3 offset_column;

    /** Column with cross-validation fold index assignment per observation */
    public ColSpecifierV3 fold_column;

    /** Cross-validation fold assignment scheme, if fold_column is not specified */
    public FoldAssignmentScheme fold_assignment;

    /** Ignored columns */
    public String[] ignored_columns;

    /** Ignore constant columns */
    public boolean ignore_const_cols;

    /** Whether to score during each iteration of model training */
    public boolean score_each_iteration;

    /** Model checkpoint to resume training with */
    public ModelKeyV3 checkpoint;

    /** Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) */
    public int stopping_rounds;

    /** Maximum allowed runtime in seconds for model training. Use 0 to disable. */
    public double max_runtime_secs;

    /** Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) */
    public StoppingMetric stopping_metric;

    /** Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) */
    public double stopping_tolerance;

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
