package water.bindings.pojos;

import com.google.gson.Gson;
public class SVDParametersV99 extends ModelParametersSchema {
    /** Transformation of training data */
    public TransformType transform;

    /** Method for computing SVD (Caution: Power and Randomized are currently experimental and unstable) */
    public Method svd_method;

    /** Number of right singular vectors */
    public int nv;

    /** Maximum iterations */
    public int max_iterations;

    /** RNG seed for k-means++ initialization */
    public long seed;

    /** Save left singular vectors? */
    public boolean keep_u;

    /** Frame key to save left singular vectors */
    public String u_name;

    /** Whether first factor level is included in each categorical expansion */
    public boolean use_all_factor_levels;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
     * public ModelKeyV3 model_id;
     */

    /* INHERITED: Training frame 
     * public FrameKeyV3 training_frame;
     */

    /* INHERITED: Validation frame 
     * public FrameKeyV3 validation_frame;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
     * public int nfolds;
     */

    /* INHERITED: Keep cross-validation model predictions 
     * public boolean keep_cross_validation_predictions;
     */

    /* INHERITED: Keep cross-validation fold assignment 
     * public boolean keep_cross_validation_fold_assignment;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
     * public boolean parallelize_cross_validation;
     */

    /* INHERITED: Response column 
     * public ColSpecifierV3 response_column;
     */

    /* INHERITED: Column with observation weights 
     * public ColSpecifierV3 weights_column;
     */

    /* INHERITED: Offset column 
     * public ColSpecifierV3 offset_column;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
     * public ColSpecifierV3 fold_column;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
     * public FoldAssignmentScheme fold_assignment;
     */

    /* INHERITED: Ignored columns 
     * public String[] ignored_columns;
     */

    /* INHERITED: Ignore constant columns 
     * public boolean ignore_const_cols;
     */

    /* INHERITED: Whether to score during each iteration of model training 
     * public boolean score_each_iteration;
     */

    /* INHERITED: Model checkpoint to resume training with 
     * public ModelKeyV3 checkpoint;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
     * public int stopping_rounds;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
     * public double max_runtime_secs;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
     * public StoppingMetric stopping_metric;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
     * public double stopping_tolerance;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
