package water.bindings.pojos;

import com.google.gson.Gson;
public class SplitFrameV3 extends RequestSchema {
    /** Job Key */
    public JobKeyV3 key;

    /** Dataset */
    public FrameKeyV3 dataset;

    /** Split ratios - resulting number of split is ratios.length+1 */
    public double[] ratios;

    /** Destination keys for each output frame split. */
    public FrameKeyV3[] destination_frames;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
     * public String _exclude_fields;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
