package water.bindings.pojos;

import com.google.gson.Gson;
public class TabulateV3 extends RequestSchema {
    /** Dataset */
    public FrameKeyV3 dataset;

    /** Predictor */
    public ColSpecifierV3 predictor;

    /** Response */
    public ColSpecifierV3 response;

    /** Observation weights (optional) */
    public ColSpecifierV3 weight;

    /** Number of bins for predictor column */
    public int nbins_predictor;

    /** Number of bins for response column */
    public int nbins_response;

    /** Counts table */
    public TwoDimTableV3 count_table;

    /** Response table */
    public TwoDimTableV3 response_table;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
     * public String _exclude_fields;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
