package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface ImportSQLTable {
    /** Import SQL table into an H2O Frame. */
    @FormUrlEncoded
    @POST("/99/ImportSQLTable")
    Call<JobV3> importSQLTable(@Field("database_sys") String database_sys,
                               @Field("database") String database,
                               @Field("table") String table,
                               @Field("username") String username,
                               @Field("password") String password,
                               @Field("host") String host,
                               @Field("port") String port,
                               @Field("optimize") boolean optimize,
                               @Field("_exclude_fields") String _exclude_fields);
}
