package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;
import java.util.Map;

public interface Jobs {
    /** Get a list of all the H2O Jobs (long-running actions). */
    @GET("/3/Jobs")
    Call<JobsV3> list();

    /** Get the status of the given H2O Job (long-running action). */
    @GET("/3/Jobs/{job_id}")
    Call<JobsV3> fetch(@Path("job_id") String job_id);

    /** Cancel a running job. */
    @FormUrlEncoded
    @POST("/3/Jobs/{job_id}/cancel")
    Call<JobsV3> cancel(@Path("job_id") String job_id,
                        @Field("_exclude_fields") String _exclude_fields);
}
