package water.bindings.pojos;

import com.google.gson.Gson;
import java.util.Map;

public class GLRMModelOutputV3 extends ModelOutputSchema {
    /** Iterations executed */
    public int iterations;

    /** Updates executed */
    public int updates;

    /** Objective value */
    public double objective;

    /** Average change in objective value on final iteration */
    public double avg_change_obj;

    /** Final step size */
    public double step_size;

    /** Mapping from lower dimensional k-space to training features */
    public TwoDimTableV3 archetypes;

    /** Singular values of XY matrix */
    public double[] singular_vals;

    /** Eigenvectors of XY matrix */
    public TwoDimTableV3 eigenvectors;

    /** Frame key name for X matrix */
    public String representation_name;

    /* INHERITED: Column names 
     * public String[] names;
     */

    /* INHERITED: Domains for categorical columns 
     * public String[][] domains;
     */

    /* INHERITED: Cross-validation models (model ids) 
     * public ModelKeyV3[] cross_validation_models;
     */

    /* INHERITED: Cross-validation predictions, one per cv model (deprecated, use cross_validation_holdout_predictions_frame_id instead) 
     * public FrameKeyV3[] cross_validation_predictions;
     */

    /* INHERITED: Cross-validation holdout predictions (full out-of-sample predictions on training data) 
     * public FrameKeyV3 cross_validation_holdout_predictions_frame_id;
     */

    /* INHERITED: Cross-validation fold assignment (each row is assigned to one holdout fold) 
     * public FrameKeyV3 cross_validation_fold_assignment_frame_id;
     */

    /* INHERITED: Category of the model (e.g., Binomial) 
     * public ModelCategory model_category;
     */

    /* INHERITED: Model summary 
     * public TwoDimTableV3 model_summary;
     */

    /* INHERITED: Scoring history 
     * public TwoDimTableV3 scoring_history;
     */

    /* INHERITED: Training data model metrics 
     * public ModelMetricsBase training_metrics;
     */

    /* INHERITED: Validation data model metrics 
     * public ModelMetricsBase validation_metrics;
     */

    /* INHERITED: Cross-validation model metrics 
     * public ModelMetricsBase cross_validation_metrics;
     */

    /* INHERITED: Cross-validation model metrics summary 
     * public TwoDimTableV3 cross_validation_metrics_summary;
     */

    /* INHERITED: Job status 
     * public String status;
     */

    /* INHERITED: Start time in milliseconds 
     * public long start_time;
     */

    /* INHERITED: End time in milliseconds 
     * public long end_time;
     */

    /* INHERITED: Runtime in milliseconds 
     * public long run_time;
     */

    /* INHERITED: Help information for output fields 
     * public Map<String,String> help;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
