package water.bindings.pojos;

import com.google.gson.Gson;
import java.util.Map;

public class ModelOutputSchema extends Schema {
    /** Column names */
    public String[] names;

    /** Domains for categorical columns */
    public String[][] domains;

    /** Cross-validation models (model ids) */
    public ModelKeyV3[] cross_validation_models;

    /** Cross-validation predictions, one per cv model (deprecated, use cross_validation_holdout_predictions_frame_id instead) */
    public FrameKeyV3[] cross_validation_predictions;

    /** Cross-validation holdout predictions (full out-of-sample predictions on training data) */
    public FrameKeyV3 cross_validation_holdout_predictions_frame_id;

    /** Cross-validation fold assignment (each row is assigned to one holdout fold) */
    public FrameKeyV3 cross_validation_fold_assignment_frame_id;

    /** Category of the model (e.g., Binomial) */
    public ModelCategory model_category;

    /** Model summary */
    public TwoDimTableBase model_summary;

    /** Scoring history */
    public TwoDimTableBase scoring_history;

    /** Training data model metrics */
    public ModelMetricsBase training_metrics;

    /** Validation data model metrics */
    public ModelMetricsBase validation_metrics;

    /** Cross-validation model metrics */
    public ModelMetricsBase cross_validation_metrics;

    /** Cross-validation model metrics summary */
    public TwoDimTableBase cross_validation_metrics_summary;

    /** Job status */
    public String status;

    /** Start time in milliseconds */
    public long start_time;

    /** End time in milliseconds */
    public long end_time;

    /** Runtime in milliseconds */
    public long run_time;

    /** Help information for output fields */
    public Map<String,String> help;

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
