package water.bindings.pojos;

import com.google.gson.Gson;
public class ModelsBase extends RequestSchema {
    /** Name of Model of interest */
    public ModelKeyV3 model_id;

    /** Return potentially abridged model suitable for viewing in a browser */
    public boolean preview;

    /** Find and return compatible frames? */
    public boolean find_compatible_frames;

    /** Models */
    public ModelSchemaBase[] models;

    /** Compatible frames */
    public FrameV3[] compatible_frames;

    /* INHERITED: Comma-separated list of JSON field paths to exclude from the result, used like: "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta" 
     * public String _exclude_fields;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
