package water.bindings.pojos;

import com.google.gson.Gson;
public class NaiveBayesParametersV3 extends ModelParametersSchema {
    /** Balance training data class counts via over/under-sampling (for imbalanced data). */
    public boolean balance_classes;

    /** Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be automatically computed to obtain class balance during training. Requires balance_classes. */
    public float[] class_sampling_factors;

    /** Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires balance_classes. */
    public float max_after_balance_size;

    /** Maximum size (# classes) for confusion matrices to be printed in the Logs */
    public int max_confusion_matrix_size;

    /** Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable) */
    public int max_hit_ratio_k;

    /** Laplace smoothing parameter */
    public double laplace;

    /** Min. standard deviation to use for observations with not enough data */
    public double min_sdev;

    /** Cutoff below which standard deviation is replaced with min_sdev */
    public double eps_sdev;

    /** Min. probability to use for observations with not enough data */
    public double min_prob;

    /** Cutoff below which probability is replaced with min_prob */
    public double eps_prob;

    /** Compute metrics on training data */
    public boolean compute_metrics;

    /** Seed for pseudo random number generator (only used for cross-validation and fold_assignment="Random" or "AUTO") */
    public long seed;

    /* INHERITED: Destination id for this model; auto-generated if not specified 
     * public ModelKeyV3 model_id;
     */

    /* INHERITED: Training frame 
     * public FrameKeyV3 training_frame;
     */

    /* INHERITED: Validation frame 
     * public FrameKeyV3 validation_frame;
     */

    /* INHERITED: Number of folds for N-fold cross-validation 
     * public int nfolds;
     */

    /* INHERITED: Keep cross-validation model predictions 
     * public boolean keep_cross_validation_predictions;
     */

    /* INHERITED: Keep cross-validation fold assignment 
     * public boolean keep_cross_validation_fold_assignment;
     */

    /* INHERITED: Allow parallel training of cross-validation models 
     * public boolean parallelize_cross_validation;
     */

    /* INHERITED: Response column 
     * public ColSpecifierV3 response_column;
     */

    /* INHERITED: Column with observation weights 
     * public ColSpecifierV3 weights_column;
     */

    /* INHERITED: Offset column 
     * public ColSpecifierV3 offset_column;
     */

    /* INHERITED: Column with cross-validation fold index assignment per observation 
     * public ColSpecifierV3 fold_column;
     */

    /* INHERITED: Cross-validation fold assignment scheme, if fold_column is not specified 
     * public FoldAssignmentScheme fold_assignment;
     */

    /* INHERITED: Ignored columns 
     * public String[] ignored_columns;
     */

    /* INHERITED: Ignore constant columns 
     * public boolean ignore_const_cols;
     */

    /* INHERITED: Whether to score during each iteration of model training 
     * public boolean score_each_iteration;
     */

    /* INHERITED: Model checkpoint to resume training with 
     * public ModelKeyV3 checkpoint;
     */

    /* INHERITED: Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) 
     * public int stopping_rounds;
     */

    /* INHERITED: Maximum allowed runtime in seconds for model training. Use 0 to disable. 
     * public double max_runtime_secs;
     */

    /* INHERITED: Metric to use for early stopping (AUTO: logloss for classification, deviance for regression) 
     * public StoppingMetric stopping_metric;
     */

    /* INHERITED: Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much) 
     * public double stopping_tolerance;
     */

    /** Return the contents of this object as a JSON String. */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
